/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Histogram;
import org.drools.core.event.rule.impl.AfterActivationFiredEventImpl;
import org.drools.core.event.rule.impl.BeforeActivationFiredEventImpl;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsRuleTaskListener
implements AgendaEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusMetricsRuleTaskListener.class);
    private final PrometheusMetrics metrics = PrometheusKieServerExtension.getMetrics();
    private final RuntimeManager runtimeManager;
    private final KieContainer kieContainer;
    private static final String KIE_SESSION_ID_DEFAULT = "default";

    public PrometheusMetricsRuleTaskListener(RuntimeManager runtimeManager, KieContainer kieContainer) {
        this.runtimeManager = runtimeManager;
        this.kieContainer = kieContainer;
    }

    public void matchCreated(MatchCreatedEvent event) {
    }

    public void matchCancelled(MatchCancelledEvent event) {
    }

    public void beforeMatchFired(BeforeMatchFiredEvent event) {
        long nanoTime = System.nanoTime();
        BeforeActivationFiredEventImpl impl = this.getBeforeImpl(event);
        impl.setTimestamp(nanoTime);
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
        AfterActivationFiredEventImpl afterImpl = this.getAfterImpl(event);
        BeforeActivationFiredEventImpl beforeImpl = this.getBeforeImpl(afterImpl.getBeforeMatchFiredEvent());
        long startTime = beforeImpl.getTimestamp();
        long elapsed = System.nanoTime() - startTime;
        String ruleName = event.getMatch().getRule().getName();
        ReleaseId releaseId = this.kieContainer.getReleaseId();
        String containerId = this.runtimeManager.getIdentifier();
        ((Histogram.Child)this.metrics.getDroolsEvaluationTimeHistogram().labels(new String[]{containerId, KIE_SESSION_ID_DEFAULT, releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion(), ruleName})).observe((double)elapsed);
        if (logger.isDebugEnabled()) {
            logger.debug("Elapsed time: {}", (Object)elapsed);
        }
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public BeforeActivationFiredEventImpl getBeforeImpl(BeforeMatchFiredEvent e) {
        return (BeforeActivationFiredEventImpl)e;
    }

    public AfterActivationFiredEventImpl getAfterImpl(AfterMatchFiredEvent e) {
        return (AfterActivationFiredEventImpl)e;
    }
}

