/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public final class KieProtostreamMarshaller
extends ProtoStreamMarshaller {
    private final InheritableThreadLocal<String> type = new InheritableThreadLocal();
    private final ConcurrentHashMap<String, Class<?>> classByType = new ConcurrentHashMap(4);
    private final ConcurrentHashMap<Class<?>, KieMarshallerSupplier<?>> supplierByClass = new ConcurrentHashMap(2);

    void registerSchema(String fileName, String contents, Class<?> dynamicEntityClass) throws IOException {
        this.getSerializationContext().registerProtoFiles(FileDescriptorSource.fromString((String)fileName, (String)contents));
        this.getSerializationContext().getFileDescriptors().entrySet().stream().filter(p -> ((String)p.getKey()).equals(fileName)).flatMap(fd -> ((FileDescriptor)fd.getValue()).getMessageTypes().stream()).map(AnnotatedDescriptorImpl::getFullName).forEach(t -> this.classByType.put((String)t, dynamicEntityClass));
    }

    void registerMarshaller(final KieMarshallerSupplier kieMarshallerSupplier) {
        this.supplierByClass.put(kieMarshallerSupplier.getJavaClass(), kieMarshallerSupplier);
        this.getSerializationContext().registerMarshallerProvider(new SerializationContext.MarshallerProvider(){

            public BaseMarshaller<?> getMarshaller(String typeName) {
                Class classForType = (Class)KieProtostreamMarshaller.this.classByType.get(typeName);
                if (classForType != null && classForType.equals(kieMarshallerSupplier.getJavaClass())) {
                    return kieMarshallerSupplier.getMarshallerForType(typeName);
                }
                return null;
            }

            public BaseMarshaller<?> getMarshaller(Class<?> javaClass) {
                if (kieMarshallerSupplier.getJavaClass().isAssignableFrom(javaClass)) {
                    return kieMarshallerSupplier.getMarshallerForType((String)KieProtostreamMarshaller.this.type.get());
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException {
        try {
            String value = this.extractType(o);
            if (value != null) {
                this.type.set(value);
            }
            ByteBuffer byteBuffer = super.objectToBuffer(o, estimatedSize);
            return byteBuffer;
        }
        finally {
            this.type.set(null);
        }
    }

    private String extractType(Object o) {
        KieMarshallerSupplier<?> marshallerSupplier = this.lookupSupplier(o.getClass());
        if (marshallerSupplier != null) {
            return marshallerSupplier.extractTypeFromEntity(o);
        }
        return null;
    }

    private KieMarshallerSupplier<?> lookupSupplier(Class<?> clazz) {
        KieMarshallerSupplier<?> supplier = this.supplierByClass.get(clazz);
        if (supplier != null) {
            return supplier;
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            KieMarshallerSupplier<?> altSupplier = this.supplierByClass.get(superInterface);
            if (altSupplier == null) continue;
            return altSupplier;
        }
        return null;
    }

    static interface KieMarshallerSupplier<E> {
        public String extractTypeFromEntity(E var1);

        public Class<E> getJavaClass();

        public BaseMarshaller<E> getMarshallerForType(String var1);
    }
}

