/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoft;

import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.inliner.IntWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class HardSoftScoreInliner
extends ScoreInliner<HardSoftScore> {
    protected int hardScore;
    protected int softScore;

    protected HardSoftScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public IntWeightedScoreImpacter buildWeightedScoreImpacter(HardSoftScore constraintWeight) {
        if (constraintWeight.equals(HardSoftScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        int hardConstraintWeight = constraintWeight.getHardScore();
        int softConstraintWeight = constraintWeight.getSoftScore();
        if (softConstraintWeight == 0) {
            return (matchWeight, matchScoreConsumer) -> {
                int hardImpact = hardConstraintWeight * matchWeight;
                this.hardScore += hardImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardSoftScore.ofHard(hardImpact));
                }
                return () -> this.hardScore -= hardImpact;
            };
        }
        if (hardConstraintWeight == 0) {
            return (matchWeight, matchScoreConsumer) -> {
                int softImpact = softConstraintWeight * matchWeight;
                this.softScore += softImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardSoftScore.ofSoft(softImpact));
                }
                return () -> this.softScore -= softImpact;
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            int hardImpact = hardConstraintWeight * matchWeight;
            int softImpact = softConstraintWeight * matchWeight;
            this.hardScore += hardImpact;
            this.softScore += softImpact;
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(HardSoftScore.of(hardImpact, softImpact));
            }
            return () -> {
                this.hardScore -= hardImpact;
                this.softScore -= softImpact;
            };
        };
    }

    @Override
    public HardSoftScore extractScore(int initScore) {
        return HardSoftScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }

    public String toString() {
        return HardSoftScore.class.getSimpleName() + " inliner";
    }
}

