/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.kie.server.services.impl.security.ElytronIdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronUserGroupAdapter
implements UserGroupAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ElytronUserGroupAdapter.class);
    private Class<?> authorizationFailureExceptionClass = null;

    public ElytronUserGroupAdapter() {
        try {
            this.authorizationFailureExceptionClass = Class.forName("org.wildfly.security.authz.AuthorizationFailureException");
        }
        catch (Exception var2) {
            logger.info("Unable to find org.wildfly.security.authz.AuthorizationFailureException, disabling elytron adapter");
        }
    }

    protected boolean isActive() {
        return this.authorizationFailureExceptionClass != null;
    }

    public List<String> getGroupsForUser(String userId) {
        block5: {
            String userName = this.getUserName();
            logger.debug("Identifier Elytron as {}", (Object)userId);
            if (!this.isActive() || userName == null) {
                return new ArrayList<String>();
            }
            if (userId.equals(userName)) {
                logger.debug("User identified as {} but auth as {}", (Object)userId, (Object)userName);
                return this.toPrincipalRoles(userId);
            }
            try {
                if (this.runAsPrincipalExists(userId)) {
                    logger.debug("Executing run as {}", (Object)userId);
                    return this.toRunAsPrincipalRoles(userId, true);
                }
            }
            catch (Exception e) {
                logger.debug("Run as {} failed", (Object)userId);
                if (!e.getClass().isAssignableFrom(this.authorizationFailureExceptionClass)) break block5;
                logger.debug("Executing run as {} without authorization", (Object)userId);
                return this.toRunAsPrincipalRoles(userId, false);
            }
        }
        return new ArrayList<String>();
    }

    public List<String> toPrincipalRoles(String userId) {
        return this.toRoles(this.getCurrentSecurityIdentity().get());
    }

    public List<String> toRunAsPrincipalRoles(String userId, boolean authenticate) {
        return this.toRoles(this.getCurrentSecurityIdentity().get().createRunAsIdentity(userId, authenticate));
    }

    public String getUserName() {
        Optional<SecurityIdentity> identityOptional = this.getCurrentSecurityIdentity();
        return identityOptional.isPresent() ? identityOptional.get().getPrincipal().getName() : null;
    }

    public List<String> toRoles(SecurityIdentity securityIdentity) {
        if (securityIdentity == null) {
            return new ArrayList<String>();
        }
        List roles = StreamSupport.stream(securityIdentity.getRoles().spliterator(), false).collect(Collectors.toCollection(ArrayList::new));
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAsPrincipalExists(String runAsPrincipal) throws RealmUnavailableException {
        if (this.isActive() && ElytronIdentityProvider.available()) {
            SecurityDomain securityDomain = SecurityDomain.getCurrent();
            RealmIdentity realmIdentity = null;
            try {
                realmIdentity = securityDomain.getIdentity(runAsPrincipal);
                boolean bl = realmIdentity.exists();
                return bl;
            }
            finally {
                if (realmIdentity != null) {
                    realmIdentity.dispose();
                }
            }
        }
        return false;
    }

    public Optional<SecurityIdentity> getCurrentSecurityIdentity() {
        if (this.isActive() && ElytronIdentityProvider.available()) {
            return Optional.ofNullable(SecurityDomain.getCurrent().getCurrentSecurityIdentity());
        }
        return Optional.empty();
    }
}

