/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.kie.api.command.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.Reoccurring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionErrorCleanupCommand
implements org.kie.api.executor.Command,
Reoccurring {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionErrorCleanupCommand.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private long nextScheduleTimeAdd = 86400000L;

    public Date getScheduleTime() {
        if (this.nextScheduleTimeAdd < 0L) {
            return null;
        }
        long current = System.currentTimeMillis();
        Date nextSchedule = new Date(current + this.nextScheduleTimeAdd);
        logger.debug("Next schedule for job {} is set to {}", (Object)this.getClass().getSimpleName(), (Object)nextSchedule);
        return nextSchedule;
    }

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        String nextRun;
        String singleRun;
        SimpleDateFormat formatToUse = DATE_FORMAT;
        String dataFormat = (String)ctx.getData("DateFormat");
        if (dataFormat != null) {
            formatToUse = new SimpleDateFormat(dataFormat);
        }
        ExecutionResults executionResults = new ExecutionResults();
        String emfName = (String)ctx.getData("EmfName");
        if (emfName == null) {
            emfName = "org.jbpm.domain";
        }
        if ("true".equalsIgnoreCase(singleRun = (String)ctx.getData("SingleRun"))) {
            this.nextScheduleTimeAdd = -1L;
        }
        if ((nextRun = (String)ctx.getData("NextRun")) != null) {
            this.nextScheduleTimeAdd = DateTimeUtils.parseDateAsDuration((String)nextRun);
        }
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(emfName);
        String olderThan = (String)ctx.getData("OlderThan");
        String olderThanPeriod = (String)ctx.getData("OlderThanPeriod");
        String forProcess = (String)ctx.getData("ForProcess");
        String forProcessInstance = (String)ctx.getData("ForProcessInstance");
        String forDeployment = (String)ctx.getData("ForDeployment");
        if (olderThanPeriod != null) {
            long olderThanDuration = DateTimeUtils.parseDateAsDuration((String)olderThanPeriod);
            Date olderThanDate = new Date(System.currentTimeMillis() - olderThanDuration);
            olderThan = formatToUse.format(olderThanDate);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder cleanUpErrorsQuery = new StringBuilder();
        cleanUpErrorsQuery.append("delete from ExecutionErrorInfo where processInstanceId in (select processInstanceId from ProcessInstanceLog where status in (2,3))");
        if (olderThan != null && !olderThan.isEmpty()) {
            cleanUpErrorsQuery.append(" and errorDate < :olderThan");
            parameters.put("olderThan", formatToUse.parse(olderThan));
        }
        if (forProcess != null && !forProcess.isEmpty()) {
            cleanUpErrorsQuery.append(" and processId = :forProcess");
            parameters.put("forProcess", forProcess);
        }
        if (forProcessInstance != null && !forProcessInstance.isEmpty()) {
            cleanUpErrorsQuery.append(" and processInstanceId = :forProcessInstance");
            parameters.put("forProcessInstance", Long.parseLong(forProcessInstance));
        }
        if (forDeployment != null && !forDeployment.isEmpty()) {
            cleanUpErrorsQuery.append(" and deploymentId = :forDeployment");
            parameters.put("forDeployment", forDeployment);
        }
        TransactionalCommandService commandService = new TransactionalCommandService(emf);
        int deletedErrors = (Integer)commandService.execute((Command)new UpdateStringCommand(cleanUpErrorsQuery.toString(), parameters));
        logger.debug("Number of Execution errors deleted {}", (Object)deletedErrors);
        executionResults.setData("ErrorsDeleted", (Object)deletedErrors);
        return executionResults;
    }
}

