/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import javax.annotation.PostConstruct;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.jms.AsyncAuditLogReceiver;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.audit.jms.AsyncTaskLifeCycleEventReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeAsyncAuditLogReceiver
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(CompositeAsyncAuditLogReceiver.class);
    private EntityManagerFactory entityManagerFactory;
    private MessageListener processLogsReceiver;
    private MessageListener taskLogReceiver;
    private MessageListener caseInstanceLogReceiver;

    public CompositeAsyncAuditLogReceiver() {
    }

    public CompositeAsyncAuditLogReceiver(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    @PostConstruct
    public void init() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain");
        }
        this.processLogsReceiver = new AsyncAuditLogReceiver(this.entityManagerFactory);
        this.taskLogReceiver = new AsyncTaskLifeCycleEventReceiver(this.entityManagerFactory);
        this.caseInstanceLogReceiver = this.createCaseEventReceiver();
    }

    public void onMessage(Message message) {
        logger.debug("Audit log message received {}", (Object)message);
        try {
            String logType = message.getStringProperty("LogType");
            logger.debug("LogType property on message set to {}", (Object)logType);
            if ("Process".equals(logType)) {
                this.processLogsReceiver.onMessage(message);
            } else if ("Task".equals(logType)) {
                this.taskLogReceiver.onMessage(message);
            } else if ("Case".equals(logType) && this.caseInstanceLogReceiver != null) {
                this.caseInstanceLogReceiver.onMessage(message);
            } else {
                logger.warn("Unexpected message {} with log type {}, consuming and ignoring", (Object)message, (Object)logType);
            }
        }
        catch (JMSException e) {
            logger.error("Unexpected JMS exception while processing audit log message", (Throwable)e);
        }
    }

    protected MessageListener createCaseEventReceiver() {
        try {
            Class<?> caseEventReceiverClass = Class.forName("org.jbpm.casemgmt.impl.jms.AsyncCaseInstanceAuditEventReceiver");
            return (MessageListener)caseEventReceiverClass.getConstructor(EntityManagerFactory.class).newInstance(this.entityManagerFactory);
        }
        catch (Exception e) {
            logger.debug("No message listener found for case instance event receiver", (Throwable)e);
            return null;
        }
    }
}

