/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.jms;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jbpm.services.task.audit.TaskLifeCycleEventConstants;
import org.jbpm.services.task.audit.impl.model.AuditTaskData;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.audit.impl.model.TaskVariableImpl;
import org.jbpm.services.task.audit.variable.TaskIndexerManager;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.persistence.PersistableEventListener;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.soup.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTaskLifeCycleEventProducer
extends PersistableEventListener
implements TaskLifeCycleEventListener {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTaskLifeCycleEventProducer.class);
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private boolean transacted = true;
    private XStream xstream;

    public AsyncTaskLifeCycleEventProducer() {
        super(null);
        this.initXStream();
    }

    private void initXStream() {
        if (this.xstream == null) {
            this.xstream = XStreamUtils.createTrustingXStream();
            String[] voidDeny = new String[]{"void.class", "Void.class"};
            this.xstream.denyTypes(voidDeny);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void afterTaskStartedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.STARTED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 5);
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.ACTIVATED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 8);
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.CLAIMED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 8);
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.SKIPPED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 2);
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.STOPPED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 4);
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.COMPLETED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 2);
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.FAILED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 2);
    }

    public void afterTaskAddedEvent(TaskEvent event) {
        Task ti = event.getTask();
        AuditTaskImpl auditTask = this.createAuditTask(ti, event.getEventDate());
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.ADDED);
        this.sendMessage(new AuditTaskData(auditTask, taskEvent), 9);
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.EXITED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 2);
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
        Task ti = event.getTask();
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl), 8);
    }

    public void afterTaskResumedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.RESUMED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 6);
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.SUSPENDED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 6);
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
        Task ti = event.getTask();
        StringBuilder message = new StringBuilder();
        String entitiesAsString = ti.getPeopleAssignments().getPotentialOwners().stream().map(oe -> oe.getId()).collect(Collectors.joining(","));
        message.append("Forward to [" + entitiesAsString + "]");
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.FORWARDED, message.toString());
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 4);
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.DELEGATED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 4);
    }

    public void afterTaskNominatedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.NOMINATED);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 4);
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.RELEASED);
        this.sendMessage(new AuditTaskData(null, taskEvent), 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskUpdatedEvent(TaskEvent event) {
        Task ti = event.getTask();
        ArrayList<TaskEventImpl> taskEvents = new ArrayList<TaskEventImpl>();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEvent;
            String message;
            AuditTaskImpl auditTaskImpl = this.getAuditTask(persistenceContext, ti);
            if (ti.getDescription() != null && !ti.getDescription().equals(auditTaskImpl.getDescription()) || ti.getDescription() == null && auditTaskImpl.getDescription() != null) {
                message = this.getUpdateFieldLog("Description", auditTaskImpl.getDescription(), ti.getDescription());
                taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.UPDATED, message);
                taskEvents.add(taskEvent);
            }
            if (ti.getName() != null && !ti.getName().equals(auditTaskImpl.getName()) || ti.getName() == null && auditTaskImpl.getName() != null) {
                message = this.getUpdateFieldLog("Name", auditTaskImpl.getName(), ti.getName());
                taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.UPDATED, message);
                taskEvents.add(taskEvent);
            }
            if (auditTaskImpl.getPriority() != ti.getPriority().intValue()) {
                message = this.getUpdateFieldLog("Priority", String.valueOf(auditTaskImpl.getPriority()), String.valueOf(ti.getPriority()));
                taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.UPDATED, message);
                taskEvents.add(taskEvent);
            }
            if (auditTaskImpl.getDueDate() != null && ti.getTaskData().getExpirationTime() != null && auditTaskImpl.getDueDate().getTime() != ti.getTaskData().getExpirationTime().getTime() || auditTaskImpl.getDueDate() == null && ti.getTaskData().getExpirationTime() != null || auditTaskImpl.getDueDate() != null && ti.getTaskData().getExpirationTime() == null) {
                String fromDate = auditTaskImpl.getDueDate() != null ? new Date(auditTaskImpl.getDueDate().getTime()).toString() : null;
                String toDate = ti.getTaskData().getExpirationTime() != null ? ti.getTaskData().getExpirationTime().toString() : "";
                String message2 = this.getUpdateFieldLog("DueDate", fromDate, toDate);
                TaskEventImpl taskEvent2 = new TaskEventImpl(event, TaskEvent.TaskEventType.UPDATED, message2);
                taskEvents.add(taskEvent2);
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvents), 4);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void afterTaskReassignedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.DELEGATED, userId);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(ti, event.getEventDate());
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(this.getActualOwner(ti));
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, taskEvent), 4);
    }

    public void afterTaskOutputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        Task task = event.getTask();
        if (variables == null || variables.isEmpty()) {
            return;
        }
        List<TaskVariableImpl> taskVariables = this.indexVariables(task, variables, TaskVariable.VariableType.OUTPUT);
        String message = "Task output data updated";
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.UPDATED, message);
        AuditTaskImpl auditTaskImpl = this.createAuditTask(task, event.getEventDate());
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        this.sendMessage(new AuditTaskData(auditTaskImpl, Collections.singletonList(taskEvent), null, taskVariables), 2);
    }

    public void afterTaskInputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        Task task = event.getTask();
        List<TaskVariableImpl> taskVariables = this.indexVariables(task, variables, TaskVariable.VariableType.INPUT);
        this.sendMessage(new AuditTaskData(null, null, taskVariables, null), 2);
    }

    protected List<TaskVariableImpl> indexVariables(Task task, Map<String, Object> variables, TaskVariable.VariableType type) {
        TaskIndexerManager manager = TaskIndexerManager.get();
        ArrayList<TaskVariableImpl> taskVariables = new ArrayList<TaskVariableImpl>();
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            List<TaskVariable> taskVars;
            if (TaskLifeCycleEventConstants.SKIPPED_TASK_VARIABLES.contains(variable.getKey()) || variable.getValue() == null || (taskVars = manager.index(task, variable.getKey(), variable.getValue())) == null) continue;
            for (TaskVariable tVariable : taskVars) {
                tVariable.setType(type);
                taskVariables.add((TaskVariableImpl)tVariable);
            }
        }
        return taskVariables;
    }

    public void afterTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.assignmentsUpdated(event, type, entities, "] have been added");
    }

    public void afterTaskAssignmentsRemovedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.assignmentsUpdated(event, type, entities, "] have been removed");
    }

    protected void assignmentsUpdated(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities, String messageSufix) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        switch (type) {
            case POT_OWNER: {
                message.append("Potential owners [");
                break;
            }
            case EXCL_OWNER: {
                message.append("Excluded owners [");
                break;
            }
            case ADMIN: {
                message.append("Business administrators [");
                break;
            }
        }
        message.append(entities.stream().map(oe -> oe.getId()).collect(Collectors.joining(",")));
        message.append(messageSufix);
        TaskEventImpl taskEvent = new TaskEventImpl(event, TaskEvent.TaskEventType.UPDATED, message.toString());
        this.sendMessage(new AuditTaskData(null, taskEvent), 2);
    }

    protected String getUpdateFieldLog(String fieldName, String previousValue, String value) {
        return "Updated " + fieldName + " {From: '" + (previousValue != null ? previousValue : "") + "' to: '" + (value != null ? value : "") + "'}";
    }

    protected String getActualOwner(Task ti) {
        String userId = "";
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        return userId;
    }

    protected AuditTaskImpl createAuditTask(Task ti, Date date) {
        AuditTaskImpl auditTaskImpl = new AuditTaskImpl(ti.getId(), ti.getName(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ti.getTaskData().getActualOwner() != null ? ti.getTaskData().getActualOwner().getId() : "", ti.getDescription(), ti.getPriority(), ti.getTaskData().getCreatedBy() != null ? ti.getTaskData().getCreatedBy().getId() : "", ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getDeploymentId(), ti.getTaskData().getParentId(), ti.getTaskData().getWorkItemId(), date);
        return auditTaskImpl;
    }

    protected void sendMessage(AuditTaskData auditTaskData, int priority) {
        if (this.connectionFactory == null && this.queue == null) {
            throw new IllegalStateException("ConnectionFactory and Queue cannot be null");
        }
        Connection queueConnection = null;
        Session queueSession = null;
        MessageProducer producer = null;
        try {
            queueConnection = this.connectionFactory.createConnection();
            queueSession = queueConnection.createSession(this.transacted, 1);
            String eventXml = this.xstream.toXML((Object)auditTaskData);
            TextMessage message = queueSession.createTextMessage(eventXml);
            message.setStringProperty("LogType", "Task");
            producer = queueSession.createProducer((Destination)this.queue);
            producer.setPriority(priority);
            producer.send((Message)message);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when sending JMS message with working memory event", e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing producer", (Throwable)e);
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue session", (Throwable)e);
                }
            }
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue connection", (Throwable)e);
                }
            }
        }
    }

    protected AuditTaskImpl getAuditTask(TaskPersistenceContext persistenceContext, Task ti) {
        AuditTaskImpl auditTaskImpl = (AuditTaskImpl)persistenceContext.queryWithParametersInTransaction("getAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(AuditTaskImpl.class));
        return auditTaskImpl;
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void beforeTaskNominatedEvent(TaskEvent event) {
    }

    public void beforeTaskUpdatedEvent(TaskEvent event) {
    }

    public void beforeTaskReassignedEvent(TaskEvent event) {
    }

    public void beforeTaskNotificationEvent(TaskEvent event) {
    }

    public void afterTaskNotificationEvent(TaskEvent event) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof AsyncTaskLifeCycleEventProducer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)((Object)this)).getClass().getName().hashCode();
        return result;
    }
}

