/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.backend.infinispan.InfinispanSearchConfig;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanContext;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanIndexProvider;
import org.uberfire.ext.metadata.backend.infinispan.provider.MappingProvider;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;
import org.uberfire.ext.metadata.backend.lucene.fields.FieldFactory;
import org.uberfire.ext.metadata.backend.lucene.fields.SimpleFieldFactory;
import org.uberfire.ext.metadata.backend.lucene.index.CustomAnalyzerWrapperFactory;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexFactory;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryType;
import org.uberfire.ext.metadata.backend.lucene.provider.LuceneIndexProvider;
import org.uberfire.ext.metadata.engine.IndexManager;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.event.IndexEvent;
import org.uberfire.ext.metadata.io.index.MetadataIndexEngine;
import org.uberfire.ext.metadata.metamodel.InMemoryMetaModelStore;
import org.uberfire.ext.metadata.metamodel.NullMetaModelStore;
import org.uberfire.ext.metadata.provider.IndexProvider;

public class MetadataConfigBuilder {
    private static final String LUCENE = "lucene";
    private static final String ISPN = "infinispan";
    public static final String ORG_UBERFIRE_EXT_METADATA_INDEX = "org.appformer.ext.metadata.index";
    private static final Consumer<List<IndexEvent>> NOP_OBSERVER = o -> {};
    private MetaModelStore metaModelStore;
    private FieldFactory fieldFactory;
    private DirectoryType type;
    private Analyzer analyzer;
    private CustomAnalyzerWrapperFactory customAnalyzerWrapperFactory;
    private Map<String, Analyzer> analyzers;
    private final String metadataIndex;

    public MetadataConfigBuilder() {
        this(System.getProperty(ORG_UBERFIRE_EXT_METADATA_INDEX, LUCENE));
    }

    public MetadataConfigBuilder(String metadataIndex) {
        this.metadataIndex = metadataIndex;
    }

    public MetadataConfigBuilder withInMemoryMetaModelStore() {
        this.metaModelStore = new InMemoryMetaModelStore();
        return this;
    }

    public MetadataConfigBuilder withoutMemoryMetaModel() {
        this.metaModelStore = new NullMetaModelStore();
        return this;
    }

    public MetadataConfigBuilder withDefaultFieldFactory() {
        this.fieldFactory = new SimpleFieldFactory();
        return this;
    }

    public MetadataConfigBuilder usingAnalyzers(Map<String, Analyzer> analyzers) {
        this.analyzers = analyzers;
        return this;
    }

    public MetadataConfigBuilder usingAnalyzerWrapperFactory(CustomAnalyzerWrapperFactory analyzerWrapper) {
        this.customAnalyzerWrapperFactory = analyzerWrapper;
        return this;
    }

    public MetadataConfigBuilder usingFieldFactory(FieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
        return this;
    }

    public MetadataConfigBuilder useDirectoryBasedIndex() {
        return this;
    }

    public MetadataConfigBuilder useInMemoryDirectory() {
        this.type = DirectoryType.INMEMORY;
        return this;
    }

    public MetadataConfigBuilder useMMapDirectory() {
        this.type = DirectoryType.MMAP;
        return this;
    }

    public MetadataConfigBuilder useNIODirectory() {
        this.type = DirectoryType.NIO;
        return this;
    }

    public MetadataConfig build() {
        if (this.metaModelStore == null) {
            this.withoutMemoryMetaModel();
        }
        if (this.fieldFactory == null) {
            this.withDefaultFieldFactory();
        }
        if (this.type == null) {
            this.withDefaultDirectory();
        }
        if (this.analyzers == null) {
            this.withDefaultAnalyzers();
        }
        if (this.analyzer == null) {
            this.withDefaultAnalyzer();
        }
        if (this.metadataIndex.toLowerCase().equals(ISPN)) {
            InfinispanContext context = InfinispanContext.getInstance();
            MappingProvider mappingProvider = new MappingProvider(this.analyzer);
            InfinispanIndexProvider infinispanIndexProvider = new InfinispanIndexProvider(context, mappingProvider);
            return new InfinispanSearchConfig((MetaIndexEngine)new MetadataIndexEngine((IndexProvider)infinispanIndexProvider, this.metaModelStore), infinispanIndexProvider, this.metaModelStore, this.analyzer);
        }
        DirectoryFactory indexFactory = new DirectoryFactory(this.type, this.analyzer);
        LuceneIndexManager indexManager = new LuceneIndexManager((LuceneIndexFactory)indexFactory);
        LuceneIndexProvider indexProvider = new LuceneIndexProvider((IndexManager)indexManager, this.fieldFactory);
        return new LuceneConfig(this.metaModelStore, this.fieldFactory, indexManager, (MetaIndexEngine)new MetadataIndexEngine((IndexProvider)indexProvider, this.metaModelStore), this.analyzer);
    }

    public void withDefaultDirectory() {
        this.useNIODirectory();
    }

    public void withDefaultAnalyzers() {
        this.analyzers = new HashMap<String, Analyzer>();
        this.analyzers.put("filename", (Analyzer)new FilenameAnalyzer());
    }

    public void withDefaultAnalyzer() {
        this.analyzer = this.customAnalyzerWrapperFactory.getAnalyzerWrapper((Analyzer)new StandardAnalyzer(CharArraySet.EMPTY_SET), this.analyzers);
    }
}

