/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.CachingPublicKeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.UnknownCommand;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.common.PortUtil;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitReceiveCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitUploadCommand;
import org.uberfire.java.nio.security.SSHAuthenticator;

public class GitSSHService {
    private static final Logger LOG = LoggerFactory.getLogger(GitSSHService.class);
    private SshServer sshd;
    private AuthenticationService authenticationService;
    private SSHAuthenticator sshAuthenticator;

    private SshServer buildSshServer(String ciphersConfigured, String macsConfigured) {
        return (SshServer)((ServerBuilder)((ServerBuilder)ServerBuilder.builder().cipherFactories(this.checkAndSetGitCiphers(ciphersConfigured))).macFactories(this.checkAndSetGitMacs(macsConfigured))).build();
    }

    public void setup(File certDir, InetSocketAddress inetSocketAddress, String sshIdleTimeout, String algorithm, ReceivePackFactory receivePackFactory, UploadPackFactory uploadPackFactory, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, ExecutorService executorService) {
        this.setup(certDir, inetSocketAddress, sshIdleTimeout, algorithm, receivePackFactory, uploadPackFactory, repositoryResolver, executorService, null, null);
    }

    public void setup(File certDir, InetSocketAddress inetSocketAddress, String sshIdleTimeout, String algorithm, ReceivePackFactory receivePackFactory, UploadPackFactory uploadPackFactory, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, ExecutorService executorService, String gitSshCiphers, String gitSshMacs) {
        PortablePreconditions.checkNotNull((String)"certDir", (Object)certDir);
        PortablePreconditions.checkNotEmpty((String)"sshIdleTimeout", (String)sshIdleTimeout);
        PortablePreconditions.checkNotEmpty((String)"algorithm", (String)algorithm);
        PortablePreconditions.checkNotNull((String)"receivePackFactory", (Object)receivePackFactory);
        PortablePreconditions.checkNotNull((String)"uploadPackFactory", (Object)uploadPackFactory);
        PortablePreconditions.checkNotNull((String)"repositoryResolver", repositoryResolver);
        this.buildSSHServer(gitSshCiphers, gitSshMacs);
        this.sshd.getProperties().put(CoreModuleProperties.IDLE_TIMEOUT.getName(), sshIdleTimeout);
        if (inetSocketAddress != null) {
            this.sshd.setHost(inetSocketAddress.getHostName());
            this.sshd.setPort(PortUtil.validateOrGetNew(inetSocketAddress.getPort()));
            if (inetSocketAddress.getPort() != this.sshd.getPort()) {
                LOG.error("SSH for Git original port {} not available, new free port {} assigned.", (Object)inetSocketAddress.getPort(), (Object)this.sshd.getPort());
            }
        }
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        SimpleGeneratorHostKeyProvider keyPairProvider = new SimpleGeneratorHostKeyProvider(certDir.toPath().resolve("hostkey.ser"));
        try {
            SecurityUtils.getKeyPairGenerator((String)algorithm);
            keyPairProvider.setAlgorithm(algorithm);
        }
        catch (Exception ignore) {
            throw new RuntimeException(String.format("Can't use '%s' algorithm for ssh key pair generator.", algorithm), ignore);
        }
        this.sshd.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        this.sshd.setCommandFactory((channel, command) -> {
            if (command.startsWith("git-upload-pack")) {
                return new GitUploadCommand(command, repositoryResolver, uploadPackFactory, executorService);
            }
            if (command.startsWith("git-receive-pack")) {
                return new GitReceiveCommand(command, repositoryResolver, (ReceivePackFactory<BaseGitCommand>)receivePackFactory, executorService);
            }
            return new UnknownCommand(command);
        });
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new CachingPublicKeyAuthenticator((username, key, session) -> {
            User user = this.getSshAuthenticator().authenticate(username, key);
            if (user == null) {
                return false;
            }
            session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)user);
            return true;
        }));
        this.sshd.setPasswordAuthenticator((username, password, session) -> {
            User user = this.getUserPassAuthenticator().login(username, password);
            if (user == null) {
                return false;
            }
            session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)user);
            return true;
        });
    }

    private void buildSSHServer(String gitSshCiphers, String gitSshMacs) {
        this.sshd = this.buildSshServer(gitSshCiphers, gitSshMacs);
    }

    private List<NamedFactory<Cipher>> checkAndSetGitCiphers(String gitSshCiphers) {
        if (gitSshCiphers == null || gitSshCiphers.isEmpty()) {
            return BaseBuilder.setUpDefaultCiphers((boolean)true);
        }
        return Arrays.asList(gitSshCiphers.split(",")).stream().map(c -> BuiltinCiphers.fromFactoryName((String)c.trim().toLowerCase())).filter(c -> c != null).collect(Collectors.toList());
    }

    private List<NamedFactory<Mac>> checkAndSetGitMacs(String gitSshMacs) {
        if (gitSshMacs == null || gitSshMacs.isEmpty()) {
            return BaseBuilder.setUpDefaultMacs((boolean)true);
        }
        return Arrays.asList(gitSshMacs.split(",")).stream().map(m -> BuiltinMacs.fromFactoryName((String)m.trim().toLowerCase())).filter(c -> c != null).collect(Collectors.toList());
    }

    public void stop() {
        try {
            this.sshd.stop(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't start SSH daemon at " + this.sshd.getHost() + ":" + this.sshd.getPort(), e);
        }
    }

    public boolean isRunning() {
        return !this.sshd.isClosed() && !this.sshd.isClosing();
    }

    SshServer getSshServer() {
        return this.sshd;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.sshd.getProperties());
    }

    public AuthenticationService getUserPassAuthenticator() {
        return this.authenticationService;
    }

    public void setUserPassAuthenticator(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public SSHAuthenticator getSshAuthenticator() {
        return this.sshAuthenticator;
    }

    public void setSshAuthenticator(SSHAuthenticator sshAuthenticator) {
        this.sshAuthenticator = sshAuthenticator;
    }
}

