/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.MessageDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.SignalDesc;
import org.jbpm.services.api.model.SignalDescBase;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.builder.ReleaseIdComparator;
import org.kie.api.definition.process.Node;
import org.kie.server.services.jbpm.kafka.KafkaServerEventProcessor;
import org.kie.server.services.jbpm.kafka.KafkaServerUtils;

class KafkaServerRegistration {
    private Map<String, Map<SignalDesc, Map<DeploymentId, SortedSet<VersionedDeploymentId>>>> topic2Signal = new HashMap<String, Map<SignalDesc, Map<DeploymentId, SortedSet<VersionedDeploymentId>>>>();
    private Map<String, Map<MessageDesc, Map<DeploymentId, SortedSet<VersionedDeploymentId>>>> topic2Message = new HashMap<String, Map<MessageDesc, Map<DeploymentId, SortedSet<VersionedDeploymentId>>>>();

    KafkaServerRegistration() {
    }

    synchronized void close() {
        this.topic2Signal.clear();
        this.topic2Message.clear();
    }

    synchronized boolean isEmpty() {
        return this.topic2Signal.isEmpty() && this.topic2Message.isEmpty();
    }

    synchronized Set<String> addRegistration(DeploymentEvent event) {
        for (DeployedAsset asset : event.getDeployedUnit().getDeployedAssets()) {
            this.updateTopics(new DeploymentIdFactory(event), (ProcessDefinition)asset);
        }
        return this.getTopicsRegistered();
    }

    synchronized Set<String> removeRegistration(DeploymentEvent event, Consumer<String> topicProcessed) {
        for (DeployedAsset asset : event.getDeployedUnit().getDeployedAssets()) {
            this.removeTopics(new DeploymentIdFactory(event), (ProcessDefinition)asset, topicProcessed);
        }
        return this.getTopicsRegistered();
    }

    private Set<String> getTopicsRegistered() {
        HashSet<String> topics = new HashSet<String>();
        topics.addAll(this.topic2Signal.keySet());
        topics.addAll(this.topic2Message.keySet());
        return topics;
    }

    private void updateTopics(DeploymentIdFactory deploymentId, ProcessDefinition processDefinition) {
        if (KafkaServerUtils.processSignals()) {
            this.addTopics(this.topic2Signal, deploymentId, processDefinition.getSignalsDesc());
        }
        if (KafkaServerUtils.processMessages()) {
            this.addTopics(this.topic2Message, deploymentId, processDefinition.getMessagesDesc());
        }
    }

    private void removeTopics(DeploymentIdFactory deploymentId, ProcessDefinition processDefinition, Consumer<String> topicProcessed) {
        this.removeTopics(this.topic2Signal, deploymentId, processDefinition.getSignalsDesc(), topicProcessed);
        this.removeTopics(this.topic2Message, deploymentId, processDefinition.getMessagesDesc(), topicProcessed);
    }

    void forEachSignal(ConsumerRecord<String, byte[]> event, KafkaServerEventProcessor<SignalDesc> eventProcessor) {
        this.forEach(this.topic2Signal, event, eventProcessor);
    }

    void forEachMessage(ConsumerRecord<String, byte[]> event, KafkaServerEventProcessor<MessageDesc> eventProcessor) {
        this.forEach(this.topic2Message, event, eventProcessor);
    }

    private synchronized <T extends SignalDescBase> void forEach(Map<String, Map<T, Map<DeploymentId, SortedSet<VersionedDeploymentId>>>> topic2SignalBase, ConsumerRecord<String, byte[]> event, KafkaServerEventProcessor<T> processor) {
        Map<T, Map<DeploymentId, SortedSet<VersionedDeploymentId>>> signalInfo = topic2SignalBase.get(event.topic());
        if (signalInfo != null) {
            for (Map.Entry<T, Map<DeploymentId, SortedSet<VersionedDeploymentId>>> entry : signalInfo.entrySet()) {
                SignalDescBase signal = (SignalDescBase)entry.getKey();
                boolean isStartNode = KafkaServerRegistration.isStartNode(signal);
                for (Map.Entry<DeploymentId, SortedSet<VersionedDeploymentId>> deploymentIdEntry : entry.getValue().entrySet()) {
                    if (isStartNode) {
                        processor.accept(event, deploymentIdEntry.getValue().first().getDeploymentId(), signal);
                        continue;
                    }
                    for (VersionedDeploymentId id : deploymentIdEntry.getValue()) {
                        processor.accept(event, id.getDeploymentId(), signal);
                    }
                }
            }
        }
    }

    private static boolean isStartNode(SignalDescBase signalDesc) {
        for (Node node : signalDesc.getIncomingNodes()) {
            if (!(node instanceof StartNode)) continue;
            return true;
        }
        return false;
    }

    private <T extends SignalDescBase> void addTopics(Map<String, Map<T, Map<DeploymentId, SortedSet<VersionedDeploymentId>>>> topic2SignalBase, DeploymentIdFactory deploymentIdFactory, Collection<T> signals) {
        for (SignalDescBase signal : signals) {
            Collection nodes = signal.getIncomingNodes();
            if (nodes.isEmpty()) continue;
            topic2SignalBase.computeIfAbsent(KafkaServerUtils.topicFromSignal(signal), k -> new HashMap()).computeIfAbsent(signal, k -> new HashMap()).computeIfAbsent(deploymentIdFactory.getUnversionDeploymentId(), k -> new TreeSet()).add(deploymentIdFactory.getVersionedDeploymentId());
        }
    }

    private <T extends SignalDescBase> void removeTopics(Map<String, Map<T, Map<DeploymentId, SortedSet<VersionedDeploymentId>>>> topic2SignalBase, DeploymentIdFactory deploymentIdFactory, Collection<T> signalsDesc, Consumer<String> topicProcessed) {
        HashSet<String> topicsPerDeployment = new HashSet<String>();
        for (SignalDescBase signal : signalsDesc) {
            Map<DeploymentId, SortedSet<VersionedDeploymentId>> deploymentIds;
            String topic = KafkaServerUtils.topicFromSignal(signal);
            Map<T, Map<DeploymentId, SortedSet<VersionedDeploymentId>>> signals = topic2SignalBase.get(topic);
            if (signals == null || (deploymentIds = signals.get(signal)) == null) continue;
            SortedSet<VersionedDeploymentId> deploymentFullIds = deploymentIds.get(deploymentIdFactory.getUnversionDeploymentId());
            if (deploymentFullIds != null && deploymentFullIds.remove(deploymentIdFactory.getVersionedDeploymentId())) {
                topicsPerDeployment.add(topic);
                if (deploymentFullIds.isEmpty()) {
                    deploymentIds.remove(deploymentIdFactory.getUnversionDeploymentId());
                }
            }
            if (!deploymentIds.isEmpty()) continue;
            signals.remove(signal);
            if (!signals.isEmpty()) continue;
            topic2SignalBase.remove(topic);
        }
        for (String removed : topicsPerDeployment) {
            topicProcessed.accept(removed);
        }
    }

    private static class VersionedDeploymentId
    implements Comparable<VersionedDeploymentId> {
        private final String deploymentId;
        private final ReleaseIdComparator.ComparableVersion version;

        public VersionedDeploymentId(String version, String deploymentId) {
            this.deploymentId = deploymentId;
            this.version = version != null ? new ReleaseIdComparator.ComparableVersion(version) : null;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public int hashCode() {
            return Objects.hash(this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VersionedDeploymentId)) {
                return false;
            }
            VersionedDeploymentId other = (VersionedDeploymentId)obj;
            return Objects.equals(this.version, other.version);
        }

        public String toString() {
            return "VersionedDeploymentId [deploymentId=" + this.deploymentId + ", version=" + this.version + "]";
        }

        @Override
        public int compareTo(VersionedDeploymentId o) {
            if (o.version == null) {
                return this.version == null ? 0 : -1;
            }
            return o.version.compareTo(this.version);
        }
    }

    private static class DeploymentId {
        private String groupId;
        private String artifactId;

        public DeploymentId(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public int hashCode() {
            return Objects.hash(this.artifactId, this.groupId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DeploymentId)) {
                return false;
            }
            DeploymentId other = (DeploymentId)obj;
            return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.groupId, other.groupId);
        }

        public String toString() {
            return "DeploymentId [groupId=" + this.groupId + ", artifactId=" + this.artifactId + "]";
        }
    }

    private static class DeploymentIdFactory {
        private final VersionedDeploymentId versionedDeploymentId;
        private final DeploymentId unversionDeploymentId;

        public DeploymentIdFactory(DeploymentEvent event) {
            String version;
            String artifactId;
            String groupId;
            String deploymentId = event.getDeploymentId();
            if (event.getDeployedUnit().getDeploymentUnit() instanceof KModuleDeploymentUnit) {
                KModuleDeploymentUnit kModule = (KModuleDeploymentUnit)event.getDeployedUnit().getDeploymentUnit();
                groupId = kModule.getGroupId();
                artifactId = kModule.getArtifactId();
                version = kModule.getVersion();
            } else {
                String[] tokens = deploymentId.split(":");
                if (tokens.length >= 3) {
                    groupId = tokens[0];
                    artifactId = tokens[1];
                    version = tokens[2];
                } else {
                    groupId = null;
                    artifactId = deploymentId;
                    version = null;
                }
            }
            this.versionedDeploymentId = new VersionedDeploymentId(version, deploymentId);
            this.unversionDeploymentId = new DeploymentId(groupId, artifactId);
        }

        public VersionedDeploymentId getVersionedDeploymentId() {
            return this.versionedDeploymentId;
        }

        public DeploymentId getUnversionDeploymentId() {
            return this.unversionDeploymentId;
        }
    }
}

