/*
 * Decompiled with CFR 0.152.
 */
package org.kie.bc.validation;

import java.io.File;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;

public class DeploymentValidator
implements Extension {
    public void validateNiogit(@Observes BeforeBeanDiscovery bbd) {
        File niogit = this.getNiogitDir();
        if (niogit.exists()) {
            this.failIfNotMigrated(niogit);
        }
    }

    private File getNiogitDir() {
        ConfigProperties configProperties = new ConfigProperties(System.getProperties());
        JGitFileSystemProviderConfiguration providerConfig = new JGitFileSystemProviderConfiguration();
        providerConfig.load(configProperties);
        File niogit = providerConfig.getGitReposParentDir();
        return niogit;
    }

    private void failIfNotMigrated(File niogit) {
        File oldSystemGit = new File(niogit, "system.git");
        if (oldSystemGit.exists()) {
            throw new IllegalStateException(String.format("The configured repository folder contains unmigrated repositories from a previous version. Please use the repository migration tool to update the repository layout.\n\tRepositories directory: %s", niogit));
        }
    }
}

