/*
 * Decompiled with CFR 0.152.
 */
package org.kie.bc.security;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.backend.server.authz.AuthorizationPolicyDeployer;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchACLTest {
    static final String HOME_PERSPECTIVE = "HomePerspective";
    static final List<String> DEFAULT_DENIED = Arrays.asList("perspective.read", "perspective.create", "perspective.delete", "perspective.update", "project.create", "project.build", "project.read", "project.update", "project.delete", "orgunit.create", "orgunit.read", "orgunit.update", "orgunit.delete", "repository.create", "repository.read", "repository.update", "repository.delete", "dataobject.edit", "asset.promote", "project.release", "repository.configure", "planner.available");
    static final List<String> DEVELOPER_DENIED = Arrays.asList("perspective.read.AdministrationPerspective", "perspective.read.AppsPerspective", "perspective.read.PlugInAuthoringPerspective", "perspective.read.DataSetAuthoringPerspective", "perspective.read.DataSourceManagementPerspective", "perspective.read.TaskAdmin", "orgunit.create", "orgunit.update", "orgunit.delete");
    static final List<String> ANALYST_DENIED = Arrays.asList("perspective.read.AdministrationPerspective", "perspective.read.AppsPerspective", "perspective.read.PlugInAuthoringPerspective", "perspective.read.DataSetAuthoringPerspective", "perspective.read.DataSourceManagementPerspective", "perspective.read.GuvnorM2RepoPerspective", "perspective.read.ProvisioningManagementPerspective", "perspective.read.ServerManagementPerspective", "perspective.read.TaskAdmin", "perspective.read.ExecutionErrors", "orgunit.create", "orgunit.update", "orgunit.delete", "dataobject.edit");
    static final List<String> MANAGER_GRANTED = Arrays.asList("perspective.read.HomePerspective", "perspective.read.ProcessDashboardPerspective", "perspective.read.TaskDashboardPerspective", "dashboard.manage");
    static final List<String> USER_GRANTED = Arrays.asList("perspective.read.HomePerspective", "perspective.read.UserHomePagePerspective", "perspective.read.ProcessDefinitions", "perspective.read.ProcessInstances", "perspective.read.Tasks", "perspective.read.ProcessDashboardPerspective", "perspective.read.TaskDashboardPerspective", "dashboard.manage");
    static final List<String> PROCESS_ADMIN_GRANTED = Arrays.asList("perspective.read.HomePerspective", "perspective.read.UserHomePagePerspective", "perspective.read.ProcessDefinitions", "perspective.read.ProcessInstances", "perspective.read.Tasks", "perspective.read.TaskAdmin", "perspective.read.ExecutionErrors", "perspective.read.ProcessDashboardPerspective", "perspective.read.TaskDashboardPerspective", "dashboard.manage");
    @Mock
    AuthorizationPolicyStorage storage;
    @Mock
    Event<AuthorizationPolicyDeployedEvent> deployedEvent;
    AuthorizationPolicyDeployer deployer;
    PermissionManager permissionManager;
    AuthorizationPolicy policy;

    @Before
    public void setUp() throws Exception {
        this.permissionManager = new DefaultPermissionManager();
        this.deployer = new AuthorizationPolicyDeployer(this.storage, this.permissionManager, this.deployedEvent);
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("security-policy.properties");
        Path policyDir = Paths.get(fileURL.toURI()).getParent();
        this.deployer.deployPolicy(policyDir);
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(AuthorizationPolicy.class);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy((AuthorizationPolicy)policyCaptor.capture());
        this.policy = (AuthorizationPolicy)policyCaptor.getValue();
    }

    @Test
    public void testPolicyDeployment() {
        Assert.assertNotNull((Object)this.policy);
        Assert.assertEquals((long)this.policy.getRoles().size(), (long)6L);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy(this.policy);
        ((Event)Mockito.verify(this.deployedEvent)).fire(Mockito.any());
    }

    @Test
    public void testDefaultPermissions() {
        Assert.assertEquals((Object)this.policy.getHomePerspective(), (Object)HOME_PERSPECTIVE);
        PermissionCollection pc = this.policy.getPermissions();
        for (String permissionName : DEFAULT_DENIED) {
            Permission p = pc.get(permissionName);
            Assert.assertNotNull((Object)p);
            Assert.assertEquals((Object)p.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        }
    }

    @Test
    public void testAdminPermissions() {
        this.testPermissions((Role)new RoleImpl("admin"), null, HOME_PERSPECTIVE, AuthorizationResult.ACCESS_GRANTED, null);
    }

    @Test
    public void testDeveloperPermissions() {
        this.testPermissions((Role)new RoleImpl("developer"), DEVELOPER_DENIED, HOME_PERSPECTIVE, AuthorizationResult.ACCESS_GRANTED, AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testAnalystPermissions() {
        this.testPermissions((Role)new RoleImpl("analyst"), ANALYST_DENIED, HOME_PERSPECTIVE, AuthorizationResult.ACCESS_GRANTED, AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testManagerPermissions() {
        this.testPermissions((Role)new RoleImpl("manager"), MANAGER_GRANTED, HOME_PERSPECTIVE, AuthorizationResult.ACCESS_DENIED, AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testUserPermissions() {
        this.testPermissions((Role)new RoleImpl("user"), USER_GRANTED, HOME_PERSPECTIVE, AuthorizationResult.ACCESS_DENIED, AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testProcessAdminPermissions() {
        this.testPermissions((Role)new RoleImpl("process-admin"), PROCESS_ADMIN_GRANTED, HOME_PERSPECTIVE, AuthorizationResult.ACCESS_DENIED, AuthorizationResult.ACCESS_GRANTED);
    }

    public void testPermissions(Role role, List<String> exceptionList, String homeExpected, AuthorizationResult defaultExpected, AuthorizationResult exceptionExpected) {
        Permission p;
        Assert.assertEquals((Object)(role != null ? this.policy.getHomePerspective(role) : this.policy.getHomePerspective()), (Object)homeExpected);
        PermissionCollection pc = this.policy.getPermissions(role);
        for (String permissionName : DEFAULT_DENIED) {
            if (exceptionList != null && exceptionList.contains(permissionName)) continue;
            p = pc.get(permissionName);
            Assert.assertNotNull((Object)p);
            Assert.assertEquals((Object)p.getResult(), (Object)defaultExpected);
        }
        if (exceptionList != null) {
            for (String permissionName : exceptionList) {
                p = pc.get(permissionName);
                Assert.assertNotNull((Object)p);
                Assert.assertEquals((Object)p.getResult(), (Object)exceptionExpected);
            }
        }
    }
}

