/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.SimulationWithFileName;
import org.drools.scenariosimulation.backend.util.ResourceHelper;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;

public class ScenarioJunitActivator
extends ParentRunner<SimulationWithFileName> {
    public static final String ACTIVATOR_CLASS_NAME = "ScenarioJunitActivatorTest";
    public static final Function<String, String> ACTIVATOR_CLASS_CODE = modulePackage -> String.format("package %s;\n/**\n* Do not remove this file\n*/\n@%s(%s.class)\npublic class %s {\n}", modulePackage, RunWith.class.getCanonicalName(), ScenarioJunitActivator.class.getCanonicalName(), ACTIVATOR_CLASS_NAME);

    public ScenarioJunitActivator(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected List<SimulationWithFileName> getChildren() {
        return this.getResources().map(this::parseFile).filter(this::isNotSkipFromBuild).collect(Collectors.toList());
    }

    protected Description describeChild(SimulationWithFileName child) {
        return AbstractScenarioRunner.getDescriptionForSimulation(Optional.of(child.getFileName()), child.getSimulation());
    }

    protected void runChild(SimulationWithFileName child, RunNotifier notifier) {
        KieContainer kieClasspathContainer = this.getKieContainer();
        AbstractScenarioRunner scenarioRunner = this.newRunner(kieClasspathContainer, child.getSimulation(), child.getFileName());
        scenarioRunner.run(notifier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SimulationWithFileName parseFile(String path) {
        try (Scanner scanner = new Scanner(new File(path));){
            String rawFile = scanner.useDelimiter("\\Z").next();
            SimulationWithFileName simulationWithFileName = new SimulationWithFileName(this.getXmlReader().unmarshal(rawFile).getSimulation(), path);
            return simulationWithFileName;
        }
        catch (FileNotFoundException e) {
            throw new ScenarioException("File not found, this should not happen: " + path, e);
        }
    }

    protected boolean isNotSkipFromBuild(SimulationWithFileName simulationWithFileName) {
        return !simulationWithFileName.getSimulation().getSimulationDescriptor().isSkipFromBuild();
    }

    ScenarioSimulationXMLPersistence getXmlReader() {
        return ScenarioSimulationXMLPersistence.getInstance();
    }

    Stream<String> getResources() {
        return ResourceHelper.getResourcesByExtension("scesim");
    }

    KieContainer getKieContainer() {
        return KieServices.get().getKieClasspathContainer();
    }

    AbstractScenarioRunner newRunner(KieContainer kieContainer, Simulation simulation, String fileName) {
        AbstractScenarioRunner runner = AbstractScenarioRunner.getSpecificRunnerProvider(simulation.getSimulationDescriptor()).create(kieContainer, simulation.getSimulationDescriptor(), simulation.getScenarioWithIndex());
        runner.setFileName(fileName);
        return runner;
    }
}

