/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.integration.backend.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.bpmn.backend.BPMNBackendService;
import org.kie.workbench.common.stunner.bpmn.integration.service.IntegrationService;
import org.kie.workbench.common.stunner.bpmn.integration.service.MigrateRequest;
import org.kie.workbench.common.stunner.bpmn.integration.service.MigrateResult;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.diagram.DiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingResponse;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Service
public class IntegrationServiceImpl
implements IntegrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationServiceImpl.class);
    private static final String BPMN2_EXTENSION = ".bpmn2";
    private static final String BPMN_EXTENSION = ".bpmn";
    private ProjectDiagramService diagramService;
    private IOService ioService;
    private CommentedOptionFactory optionFactory;
    private FactoryManager factoryManager;
    private BPMNBackendService definitionService;
    private KieModuleService moduleService;
    private KieServiceOverviewLoader overviewLoader;
    private String defSetId;

    public IntegrationServiceImpl() {
    }

    @Inject
    public IntegrationServiceImpl(ProjectDiagramService diagramService, BPMNBackendService definitionService, FactoryManager factoryManager, KieModuleService moduleService, KieServiceOverviewLoader overviewLoader, @Named(value="ioStrategy") IOService ioService, CommentedOptionFactory optionFactory) {
        this.diagramService = diagramService;
        this.definitionService = definitionService;
        this.factoryManager = factoryManager;
        this.moduleService = moduleService;
        this.overviewLoader = overviewLoader;
        this.ioService = ioService;
        this.optionFactory = optionFactory;
        this.defSetId = BindableAdapterUtils.getDefinitionSetId((Class)definitionService.getResourceType().getDefinitionSetType());
    }

    public MigrateResult migrateDiagram(MigrateRequest request) {
        PortablePreconditions.checkNotNull((String)"request", (Object)request);
        if (request.getType() == MigrateRequest.Type.STUNNER_TO_JBPM_DESIGNER) {
            return this.migrateFromStunnerToJBPMDesigner(request);
        }
        return this.migrateFromJBPMDesignerToStunner(request);
    }

    private MigrateResult migrateFromStunnerToJBPMDesigner(MigrateRequest request) {
        IntegrationServiceImpl.validateRequest(request);
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)request.getPath());
        Path _target = IntegrationServiceImpl.resolveTargetPath(_path, request.getNewName(), request.getNewExtension());
        org.uberfire.backend.vfs.Path target = Paths.convert((Path)_target);
        if (this.ioService.exists(_target)) {
            return new MigrateResult(target, IntegrationService.ServiceError.JBPM_DESIGNER_PROCESS_ALREADY_EXIST, IntegrationService.ServiceError.JBPM_DESIGNER_PROCESS_ALREADY_EXIST.i18nKey(), Collections.singletonList(request.getPath()));
        }
        try {
            this.ioService.startBatch(_target.getFileSystem());
            this.ioService.move(_path, _target, new CopyOption[]{this.optionFactory.makeCommentedOption(request.getCommitMessage())});
        }
        catch (Exception e) {
            String message = String.format("An error was produced during diagram migration from Stunner to jBPMDesigner for diagram: %s", request.getPath());
            LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        finally {
            this.ioService.endBatch();
        }
        return new MigrateResult(target);
    }

    private MigrateResult migrateFromJBPMDesignerToStunner(MigrateRequest request) {
        IntegrationServiceImpl.validateRequest(request);
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)request.getPath());
        Path _target = _path.resolveSibling(request.getNewName() + request.getNewExtension());
        org.uberfire.backend.vfs.Path target = Paths.convert((Path)_target);
        if (this.ioService.exists(_target)) {
            return new MigrateResult(target, IntegrationService.ServiceError.STUNNER_PROCESS_ALREADY_EXIST, IntegrationService.ServiceError.STUNNER_PROCESS_ALREADY_EXIST.i18nKey(), Collections.singletonList(request.getPath()));
        }
        ((ProjectMetadata)request.getProjectDiagram().getMetadata()).setPath(target);
        ((ProjectMetadata)request.getProjectDiagram().getMetadata()).setTitle(request.getNewName());
        this.diagramService.saveOrUpdate((Diagram)request.getProjectDiagram());
        return new MigrateResult(target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarshallingResponse<ProjectDiagram> getDiagramByPath(org.uberfire.backend.vfs.Path path, MarshallingRequest.Mode mode) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"mode", (Object)mode);
        String fileName = path.getFileName();
        String name = fileName.endsWith(BPMN_EXTENSION) ? fileName.substring(0, fileName.length() - BPMN_EXTENSION.length()) : fileName.substring(0, fileName.length() - BPMN2_EXTENSION.length());
        Package modulePackage = this.moduleService.resolvePackage(path);
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(path);
        ProjectMetadataImpl metadata = new ProjectMetadataImpl.ProjectMetadataBuilder().forDefinitionSetId(this.defSetId).forModuleName(kieModule.getModuleName()).forProjectPackage(modulePackage).forOverview(this.overviewLoader.loadOverview(path)).forTitle(name).forPath(path).build();
        try (InputStream is = this.loadPath(path);){
            MarshallingResponse marshallingResponse = this.definitionService.getDiagramMarshaller().unmarshallWithValidation(MarshallingRequest.builder().metadata((Metadata)metadata).input((Object)is).mode(mode).build());
            if (marshallingResponse.getState() == MarshallingResponse.State.ERROR) {
                MarshallingResponse marshallingResponse2 = new MarshallingResponse.MarshallingResponseBuilder().messages(marshallingResponse.getMessages()).state(marshallingResponse.getState()).result(null).build();
                return marshallingResponse2;
            }
            Graph graph = (Graph)marshallingResponse.getResult().orElseThrow(() -> new RuntimeException("Unexpected error, diagram parsing api must return a value"));
            DiagramFactory factory = this.factoryManager.registry().getDiagramFactory((String)((DefinitionSet)graph.getContent()).getDefinition(), ProjectMetadata.class);
            ProjectDiagram diagram = (ProjectDiagram)factory.build(name, (Metadata)metadata, graph);
            MarshallingResponse marshallingResponse3 = new MarshallingResponse.MarshallingResponseBuilder().messages(marshallingResponse.getMessages()).state(marshallingResponse.getState()).result((Object)diagram).build();
            return marshallingResponse3;
        }
        catch (Exception e) {
            String message = String.format("An error was produced while diagram loading from file %s:", path);
            LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    private static Path resolveTargetPath(Path currentPath, String newName, String newExtension) {
        return currentPath.resolveSibling(newName + newExtension);
    }

    private static void validateRequest(MigrateRequest request) {
        PortablePreconditions.checkNotNull((String)"request", (Object)request);
        PortablePreconditions.checkNotNull((String)"request.path", (Object)request.getPath());
        PortablePreconditions.checkNotNull((String)"request.newName", (Object)request.getNewName());
        PortablePreconditions.checkNotNull((String)"request.newExtension", (Object)request.getNewExtension());
        if (request.getType() == MigrateRequest.Type.JBPM_DESIGNER_TO_STUNNER) {
            PortablePreconditions.checkNotNull((String)"request.projectDiagram", (Object)request.getProjectDiagram());
        }
    }

    private InputStream loadPath(org.uberfire.backend.vfs.Path _path) {
        Path path = Paths.convert((org.uberfire.backend.vfs.Path)_path);
        byte[] bytes = this.ioService.readAllBytes(path);
        return new ByteArrayInputStream(bytes);
    }
}

