/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.exceptions.ProvisioningException;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeBuilder;
import org.guvnor.ala.runtime.RuntimeDestroyer;
import org.guvnor.ala.runtime.RuntimeEndpoint;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeInfo;
import org.guvnor.ala.runtime.RuntimeState;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.util.RuntimeConfigHelper;
import org.guvnor.ala.wildfly.access.WildflyAccessInterface;
import org.guvnor.ala.wildfly.access.WildflyAppState;
import org.guvnor.ala.wildfly.config.WildflyRuntimeConfiguration;
import org.guvnor.ala.wildfly.config.WildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.model.WildflyProvider;
import org.guvnor.ala.wildfly.model.WildflyRuntime;
import org.guvnor.ala.wildfly.model.WildflyRuntimeEndpoint;
import org.guvnor.ala.wildfly.model.WildflyRuntimeInfo;
import org.guvnor.ala.wildfly.model.WildflyRuntimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildflyRuntimeExecExecutor<T extends WildflyRuntimeConfiguration>
implements RuntimeBuilder<T, WildflyRuntime>,
RuntimeDestroyer,
FunctionConfigExecutor<T, WildflyRuntime> {
    private final RuntimeRegistry runtimeRegistry;
    private final WildflyAccessInterface wildfly;
    protected static final Logger LOG = LoggerFactory.getLogger(WildflyRuntimeExecExecutor.class);

    @Inject
    public WildflyRuntimeExecExecutor(RuntimeRegistry runtimeRegistry, WildflyAccessInterface wildfly) {
        this.runtimeRegistry = runtimeRegistry;
        this.wildfly = wildfly;
    }

    public Optional<WildflyRuntime> apply(WildflyRuntimeConfiguration config) {
        Optional<WildflyRuntime> runtime = this.create(config);
        if (runtime.isPresent()) {
            this.runtimeRegistry.registerRuntime((Runtime)runtime.get());
        }
        return runtime;
    }

    private Optional<WildflyRuntime> create(WildflyRuntimeConfiguration runtimeConfig) throws ProvisioningException {
        int result;
        String warPath = runtimeConfig.getWarPath();
        Optional _wildflyProvider = this.runtimeRegistry.getProvider(runtimeConfig.getProviderId(), WildflyProvider.class);
        if (!_wildflyProvider.isPresent()) {
            throw new ProvisioningException("No Wildfly provider was found for providerId: " + runtimeConfig.getProviderId());
        }
        WildflyProvider wildflyProvider = (WildflyProvider)_wildflyProvider.get();
        File file = new File(warPath);
        String id = file.getName();
        WildflyAppState appState = this.wildfly.getWildflyClient((ProviderId)wildflyProvider).getAppState(id);
        if ("UNKNOWN".equals(appState.getState())) {
            result = this.wildfly.getWildflyClient((ProviderId)wildflyProvider).deploy(file);
            if (result != 200) {
                throw new ProvisioningException("Deployment to Wildfly Failed with error code: " + result);
            }
        } else if (("RUNNING".equals(appState.getState()) || "STOPPED".equals(appState.getState())) && (Strings.isNullOrEmpty((String)runtimeConfig.getRedeployStrategy()) || "auto".equals(runtimeConfig.getRedeployStrategy()))) {
            this.wildfly.getWildflyClient((ProviderId)wildflyProvider).undeploy(id);
            result = this.wildfly.getWildflyClient((ProviderId)wildflyProvider).deploy(file);
            if (result != 200) {
                throw new ProvisioningException("Deployment to Wildfly Failed with error code: " + result);
            }
        } else {
            throw new ProvisioningException("A runtime with the given identifier: " + id + " is already deployed");
        }
        String appContext = id.substring(0, id.lastIndexOf(".war"));
        WildflyRuntimeEndpoint endpoint = new WildflyRuntimeEndpoint();
        endpoint.setHost(this.wildfly.getWildflyClient((ProviderId)wildflyProvider).getHost());
        endpoint.setPort(this.wildfly.getWildflyClient((ProviderId)wildflyProvider).getPort());
        endpoint.setContext(appContext);
        return Optional.of(new WildflyRuntime(id, RuntimeConfigHelper.buildRuntimeName((RuntimeConfig)runtimeConfig, (String)id), runtimeConfig, (ProviderId)wildflyProvider, (RuntimeEndpoint)endpoint, (RuntimeInfo)new WildflyRuntimeInfo(), (RuntimeState)new WildflyRuntimeState("RUNNING", new Date().toString())));
    }

    public Class<? extends Config> executeFor() {
        return WildflyRuntimeExecConfig.class;
    }

    public String outputId() {
        return "wildfly-runtime";
    }

    public boolean supports(RuntimeConfig config) {
        return config instanceof WildflyRuntimeConfiguration;
    }

    public boolean supports(RuntimeId runtimeId) {
        return runtimeId instanceof WildflyRuntime || this.runtimeRegistry.getRuntimeById(runtimeId.getId()) instanceof WildflyRuntime;
    }

    public void destroy(RuntimeId runtimeId) {
        Optional _wildflyProvider = this.runtimeRegistry.getProvider(runtimeId.getProviderId(), WildflyProvider.class);
        WildflyProvider wildflyProvider = (WildflyProvider)_wildflyProvider.get();
        int result = this.wildfly.getWildflyClient((ProviderId)wildflyProvider).undeploy(runtimeId.getId());
        if (result != 200) {
            throw new ProvisioningException("UnDeployment to Wildfly Failed with error code: " + result);
        }
        this.runtimeRegistry.deregisterRuntime(runtimeId);
    }
}

