/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.scorecard.backend.server.indexing;

import org.drools.workbench.models.guided.scorecard.shared.Characteristic;
import org.drools.workbench.models.guided.scorecard.shared.ScoreCardModel;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleUtils;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidedScoreCardIndexVisitor
extends ResourceReferenceCollector {
    private static final Logger logger = LoggerFactory.getLogger(GuidedScoreCardIndexVisitor.class);
    private final ModuleDataModelOracle dmo;
    private final ScoreCardModel model;

    public GuidedScoreCardIndexVisitor(ModuleDataModelOracle dmo, ScoreCardModel model) {
        this.dmo = (ModuleDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.model = (ScoreCardModel)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public void visit() {
        Imports imports;
        String ruleFlowGroup;
        String typeName = this.model.getFactName();
        if (typeName == null || typeName.isEmpty()) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
        ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
        String fieldName = this.model.getFieldName();
        if (fieldName == null || fieldName.isEmpty()) {
            return;
        }
        resRef.addPartReference(fieldName, PartType.FIELD);
        String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
        this.addResourceReference(fieldFullyQualifiedClassName, ResourceType.JAVA);
        for (Characteristic c : this.model.getCharacteristics()) {
            this.visit(c);
        }
        String agendaGroup = this.model.getAgendaGroup();
        if (agendaGroup != null && !agendaGroup.isEmpty()) {
            this.addSharedReference(agendaGroup, PartType.AGENDA_GROUP);
        }
        if ((ruleFlowGroup = this.model.getRuleFlowGroup()) != null && !ruleFlowGroup.isEmpty()) {
            this.addSharedReference(ruleFlowGroup, PartType.RULEFLOW_GROUP);
        }
        if ((imports = this.model.getImports()) != null) {
            this.visit(imports);
        }
    }

    private void visit(Imports imports) {
        for (Import imp : imports.getImports()) {
            String impStr = imp.getType();
            if (!impStr.endsWith("*")) {
                this.addResourceReference(impStr, ResourceType.JAVA);
                continue;
            }
            logger.debug("Wildcard import encountered : '" + impStr + "'");
        }
    }

    private void visit(Characteristic c) {
        String typeName = c.getFact();
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
        ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
        String fieldName = c.getField();
        String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
        resRef.addPartReference(fieldName, PartType.FIELD);
        this.addResourceReference(fieldFullyQualifiedClassName, ResourceType.JAVA);
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (Import i : this.model.getImports().getImports()) {
            if (!i.getType().endsWith(typeName)) continue;
            return i.getType();
        }
        String packageName = this.model.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + "." + typeName : typeName;
    }

    private String getFieldFullyQualifiedClassName(String fullyQualifiedClassName, String fieldName) {
        String className = ModuleDataModelOracleUtils.getFieldFullyQualifiedClassName((ModuleDataModelOracle)this.dmo, (String)fullyQualifiedClassName, (String)fieldName);
        if (className == null) {
            className = "Object";
        }
        return className;
    }
}

