/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import org.eclipse.jgit.lib.Ref;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.FileTimeImpl;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class JGitBasicAttributeView
extends AbstractBasicFileAttributeView<JGitPathImpl> {
    private BasicFileAttributes attrs = null;

    public JGitBasicAttributeView(JGitPathImpl path) {
        super((Path)path);
    }

    public BasicFileAttributes readAttributes() throws IOException {
        if (this.attrs == null) {
            this.attrs = this.buildAttrs((JGitFileSystem)((JGitPathImpl)this.path).getFileSystem(), ((JGitPathImpl)this.path).getRefTree(), ((JGitPathImpl)this.path).getPath());
        }
        return this.attrs;
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{BasicFileAttributeView.class, JGitBasicAttributeView.class};
    }

    private BasicFileAttributes buildAttrs(final JGitFileSystem fs, String branchName, String path) {
        final PathInfo pathInfo = fs.getGit().getPathInfo(branchName, path);
        if (pathInfo == null || pathInfo.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path);
        }
        final Ref ref = fs.getGit().getRef(branchName);
        return new BasicFileAttributes(){
            private FileTime lastModifiedDate = null;
            private FileTime creationDate = null;

            public FileTime lastModifiedTime() {
                if (this.lastModifiedDate == null) {
                    try {
                        this.lastModifiedDate = new FileTimeImpl(fs.getGit().getLastCommit(ref).getCommitterIdent().getWhen().getTime());
                    }
                    catch (Exception e) {
                        this.lastModifiedDate = new FileTimeImpl(0L);
                    }
                }
                return this.lastModifiedDate;
            }

            public FileTime lastAccessTime() {
                return this.lastModifiedTime();
            }

            public FileTime creationTime() {
                if (this.creationDate == null) {
                    try {
                        this.creationDate = new FileTimeImpl(fs.getGit().getFirstCommit(ref).getCommitterIdent().getWhen().getTime());
                    }
                    catch (Exception e) {
                        this.creationDate = new FileTimeImpl(0L);
                    }
                }
                return this.creationDate;
            }

            public boolean isRegularFile() {
                return pathInfo.getPathType().equals((Object)PathType.FILE);
            }

            public boolean isDirectory() {
                return pathInfo.getPathType().equals((Object)PathType.DIRECTORY);
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return pathInfo.getSize();
            }

            public Object fileKey() {
                return pathInfo.getObjectId() == null ? null : pathInfo.getObjectId().toString();
            }
        };
    }
}

