/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.kie.workbench.common.screens.library.api.SpacesScreenService;
import org.kie.workbench.common.screens.library.api.preferences.LibraryInternalPreferencesPortableGeneratedImpl;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceBeanServerStore;
import org.uberfire.rpc.SessionInfo;

@ApplicationScoped
public class SpacesScreenServiceImpl
implements SpacesScreenService {
    private OrganizationalUnitService organizationalUnitService;
    private PreferenceBeanServerStore preferenceBeanServerStore;
    private SessionInfo sessionInfo;

    public SpacesScreenServiceImpl() {
    }

    @Inject
    public SpacesScreenServiceImpl(OrganizationalUnitService organizationalUnitService, PreferenceBeanServerStore preferenceBeanServerStore, SessionInfo sessionInfo) {
        this.organizationalUnitService = organizationalUnitService;
        this.preferenceBeanServerStore = preferenceBeanServerStore;
        this.sessionInfo = sessionInfo;
    }

    public Collection<OrganizationalUnit> getSpaces() {
        return this.organizationalUnitService.getOrganizationalUnits(true);
    }

    public Response savePreference(LibraryInternalPreferencesPortableGeneratedImpl preference) {
        this.preferenceBeanServerStore.save((BasePreferencePortable)preference);
        return Response.ok().build();
    }

    public OrganizationalUnit getSpace(String name) {
        return this.organizationalUnitService.getOrganizationalUnit(name, true);
    }

    public boolean isValidGroupId(String groupId) {
        return this.organizationalUnitService.isValidGroupId(groupId);
    }

    public Response postSpace(SpacesScreenService.NewSpace newSpace) {
        this.organizationalUnitService.createOrganizationalUnit(newSpace.name, newSpace.groupId, new ArrayList(), this.getContributors());
        return Response.status((int)201).build();
    }

    private List<Contributor> getContributors() {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        contributors.add(new Contributor(this.sessionInfo.getIdentity().getIdentifier(), ContributorType.OWNER));
        return contributors;
    }
}

