/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.impl;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavItemVisitor;
import org.dashbuilder.navigation.NavTree;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class NavTreeImpl
implements NavTree {
    private NavGroup root;

    public NavTreeImpl() {
        this.root = NavFactory.get().createNavGroup();
    }

    public NavTreeImpl(NavGroup root) {
        this.root = root;
    }

    @Override
    public List<NavItem> getRootItems() {
        return this.root.getChildren();
    }

    @Override
    public NavItem getItemById(String id) {
        return this.getItemById(id, this.root.getChildren());
    }

    private NavItem getItemById(String id, List<NavItem> navItemList) {
        if (id == null) {
            return null;
        }
        for (NavItem navItem : navItemList) {
            NavItem child;
            if (navItem.getId() != null && navItem.getId().equals(id)) {
                return navItem;
            }
            if (!(navItem instanceof NavGroup) || (child = this.getItemById(id, ((NavGroup)navItem).getChildren())) == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public NavTree getItemAsTree(String id) {
        NavItem item = this.getItemById(id);
        return id != null ? NavFactory.get().createNavTree(item) : null;
    }

    @Override
    public List<NavItem> searchItems(NavItemContext ctx) {
        return this.searchItems(ctx, this.getRootItems());
    }

    public List<NavItem> searchItems(NavItemContext ctx, List<NavItem> navItemList) {
        ArrayList<NavItem> result = new ArrayList<NavItem>();
        if (ctx == null) {
            return result;
        }
        NavItemContext niCtx = NavItemContext.create();
        for (NavItem navItem : navItemList) {
            niCtx.init(navItem.getContext());
            if (niCtx.includesPropertiesOf(ctx)) {
                result.add(navItem);
            }
            if (!(navItem instanceof NavGroup)) continue;
            List<NavItem> children = this.searchItems(ctx, ((NavGroup)navItem).getChildren());
            result.addAll(children);
        }
        return result;
    }

    @Override
    public NavGroup addGroup(String id, String name, String description, String parentId, boolean modifiable) {
        NavGroup newNavItem = NavFactory.get().createNavGroup();
        newNavItem.setId(id);
        newNavItem.setName(name);
        newNavItem.setDescription(description);
        newNavItem.setModifiable(modifiable);
        this.addItem(newNavItem, parentId);
        return newNavItem;
    }

    @Override
    public NavItem addItem(String id, String name, String description, String parentId, boolean modifiable, String context) {
        NavItem newNavItem = NavFactory.get().createNavItem();
        newNavItem.setId(id);
        newNavItem.setName(name);
        newNavItem.setDescription(description);
        newNavItem.setModifiable(modifiable);
        newNavItem.setContext(context);
        this.addItem(newNavItem, parentId);
        return newNavItem;
    }

    @Override
    public NavDivider addDivider(String parentId, boolean modifiable) {
        NavDivider newNavItem = NavFactory.get().createDivider();
        newNavItem.setId(Integer.toString(newNavItem.hashCode()));
        newNavItem.setModifiable(modifiable);
        this.addItem(newNavItem, parentId);
        return newNavItem;
    }

    private void addItem(NavItem item, String parentId) {
        NavItem parent = this.getItemById(parentId);
        if (parentId != null && parent == null) {
            throw new RuntimeException("Parent '" + parentId + "' not found");
        }
        if (parent != null && !(parent instanceof NavGroup)) {
            throw new RuntimeException("Parent '" + parentId + "' is not a group");
        }
        if (parent == null) {
            item.setParent(null);
            this.root.getChildren().add(item);
        } else {
            ((NavGroup)parent).getChildren().add(item);
            item.setParent((NavGroup)parent);
        }
    }

    @Override
    public NavItem deleteItem(String id) {
        NavItem navItem = this.getItemById(id);
        if (navItem != null) {
            if (navItem.getParent() == null) {
                this.root.getChildren().remove(navItem);
            } else {
                navItem.getParent().getChildren().remove(navItem);
                navItem.setParent(null);
            }
        }
        return navItem;
    }

    @Override
    public NavItem setItemName(String id, String name) {
        NavItem navItem = this.getItemById(id);
        if (navItem == null) {
            throw new RuntimeException("Item not found: " + id);
        }
        navItem.setName(name);
        return navItem;
    }

    @Override
    public NavItem setItemDescription(String id, String description) {
        NavItem navItem = this.getItemById(id);
        if (navItem == null) {
            throw new RuntimeException("Item not found: " + id);
        }
        navItem.setDescription(description);
        return navItem;
    }

    @Override
    public NavItem setItemModifiable(String id, boolean modifiable) {
        NavItem navItem = this.getItemById(id);
        if (navItem == null) {
            throw new RuntimeException("Item not found: " + id);
        }
        navItem.setModifiable(modifiable);
        return navItem;
    }

    @Override
    public NavItem setItemContext(String id, String context) {
        NavItem navItem = this.getItemById(id);
        if (navItem == null) {
            throw new RuntimeException("Item not found: " + id);
        }
        navItem.setContext(context);
        return navItem;
    }

    @Override
    public NavItem moveItem(String id, String newParentId) {
        String parentId;
        NavItem navItem = this.getItemById(id);
        if (navItem == null) {
            throw new RuntimeException("Item not found: " + id);
        }
        NavItem newParent = this.getItemById(newParentId);
        if (newParent == null && newParentId != null) {
            throw new RuntimeException("Parent not found: " + newParentId);
        }
        if (newParent != null && !(newParent instanceof NavGroup)) {
            throw new RuntimeException("Parent '" + newParentId + "' is not a group");
        }
        if (newParentId != null && newParentId.equals(id)) {
            throw new RuntimeException("The parent can't be the item itself: " + newParentId);
        }
        String string = parentId = navItem.getParent() != null ? navItem.getParent().getId() : null;
        if (parentId == null && newParentId == null || parentId != null && newParentId != null && parentId.equals(newParentId)) {
            return navItem;
        }
        if (navItem.getParent() != null) {
            navItem.getParent().getChildren().remove(navItem);
        }
        navItem.setParent(null);
        if (newParent != null) {
            ((NavGroup)newParent).getChildren().add(navItem);
            navItem.setParent((NavGroup)newParent);
        }
        return navItem;
    }

    @Override
    public void moveItemFirst(String id) {
        this.changePosition(id, true, null);
    }

    @Override
    public void moveItemLast(String id) {
        this.changePosition(id, false, null);
    }

    @Override
    public void moveItemUp(String id) {
        this.changePosition(id, true, 1);
    }

    @Override
    public void moveItemDown(String id) {
        this.changePosition(id, false, 1);
    }

    public void changePosition(String id, boolean up, Integer npositions) {
        int newPos;
        NavItem navItem = this.getItemById(id);
        if (navItem == null) {
            throw new RuntimeException("Item not found: " + id);
        }
        NavGroup parent = navItem.getParent();
        List<NavItem> itemList = parent != null ? parent.getChildren() : this.getRootItems();
        int idx = itemList.indexOf(navItem);
        int n = npositions == null ? (up ? 0 : itemList.size() - 1) : (newPos = up ? idx - npositions : idx + npositions);
        if (up && newPos < 0 || !up && newPos > itemList.size() - 1) {
            throw new RuntimeException("Item '" + id + "' position out of range (old=" + idx + ", new=" + newPos + ")");
        }
        itemList.remove(idx);
        itemList.add(newPos, navItem);
    }

    @Override
    public void accept(NavItemVisitor visitor) {
        for (NavItem item : this.root.getChildren()) {
            item.accept(visitor);
        }
    }

    @Override
    public NavTree cloneTree() {
        NavGroup rootClone = (NavGroup)this.root.cloneItem();
        rootClone.getChildren().forEach(e -> e.setParent(null));
        return new NavTreeImpl(rootClone);
    }
}

