/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtensionHandler;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.rule.violations.RuleViolationImpl;

@ApplicationScoped
public class NoInputNodesInImportedDecisionRule
extends RuleExtensionHandler<NoInputNodesInImportedDecisionRule, GraphConnectionContext> {
    static final String ERROR_MESSAGE = "Imported nodes can not have input nodes.";

    public Class<NoInputNodesInImportedDecisionRule> getExtensionType() {
        return NoInputNodesInImportedDecisionRule.class;
    }

    public Class<GraphConnectionContext> getContextType() {
        return GraphConnectionContext.class;
    }

    public boolean accepts(RuleExtension rule, GraphConnectionContext context) {
        if (context.getTarget().isPresent()) {
            Node target = (Node)context.getTarget().get();
            View content = (View)target.getContent();
            if (Objects.isNull(content)) {
                return false;
            }
            Object definition = content.getDefinition();
            return Objects.equals(definition.getClass().getName(), rule.getId());
        }
        return false;
    }

    public RuleViolations evaluate(RuleExtension rule, GraphConnectionContext context) {
        Optional oSource = context.getSource();
        Optional oTarget = context.getTarget();
        DefaultRuleViolations result = new DefaultRuleViolations();
        if (!oSource.isPresent() || !oTarget.isPresent()) {
            return result;
        }
        if (this.isReadOnly(oTarget)) {
            result.addViolation((RuleViolation)new RuleViolationImpl(ERROR_MESSAGE));
        }
        return result;
    }

    boolean isReadOnly(Optional<Node<? extends View<?>, ? extends Edge>> oTarget) {
        Node<? extends View<?>, ? extends Edge> target = oTarget.get();
        View content = (View)target.getContent();
        if (Objects.isNull(content)) {
            return false;
        }
        Object definition = content.getDefinition();
        return definition instanceof DynamicReadOnly && ((DynamicReadOnly)definition).isAllowOnlyVisualChange();
    }
}

