/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.index;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.analyzer.ElasticSearchAnalyzerWrapper;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticMetaObject;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticMetaProperty;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticSearchMappingStore;
import org.uberfire.ext.metadata.backend.elastic.provider.ElasticSearchContext;
import org.uberfire.ext.metadata.backend.elastic.provider.MappingFieldFactory;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.schema.MetaObject;
import org.uberfire.ext.metadata.model.schema.MetaProperty;
import org.uberfire.ext.metadata.provider.IndexProvider;

public class ElasticSearchIndexProvider
implements IndexProvider {
    public static final int ELASTICSEARCH_MAX_SIZE = 10000;
    public static final String ES_TEXT_TYPE = "text";
    public static final String ES_KEYWORD_TYPE = "keyword";
    private final ElasticSearchContext elasticSearchContext;
    private final MappingFieldFactory fieldFactory;
    private final ElasticSearchMappingStore elasticSearchMappingStore;
    private final MetaModelStore metaModelStore;
    private final Analyzer analyzer;
    private Logger logger = LoggerFactory.getLogger(ElasticSearchIndexProvider.class);

    public ElasticSearchIndexProvider(MetaModelStore metaModelStore, ElasticSearchContext elasticSearchContext, Analyzer analyzer) {
        this.elasticSearchMappingStore = new ElasticSearchMappingStore(this);
        this.metaModelStore = metaModelStore;
        this.elasticSearchContext = elasticSearchContext;
        this.analyzer = analyzer;
        this.fieldFactory = new MappingFieldFactory(this.elasticSearchMappingStore);
    }

    public Client getClient() {
        return this.elasticSearchContext.getTransportClient();
    }

    public boolean isFreshIndex(KCluster cluster) {
        return this.getIndexSize(cluster.getClusterId()) == 0L;
    }

    public void index(KObject object) {
        MetaObject metaObject = this.fieldFactory.build(object);
        this.elasticSearchMappingStore.updateMetaModel(object, metaObject);
        this.deleteIfExists(object);
        ((IndexRequestBuilder)this.createIndexRequest((ElasticMetaObject)metaObject).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute().actionGet();
    }

    private void deleteIfExists(KObject object) {
        if (this.exists(object.getClusterId(), object.getId())) {
            this.delete(object.getClusterId(), object.getId());
        }
    }

    public void index(List<KObject> elements) {
        elements.forEach(kObject -> this.deleteIfExists((KObject)kObject));
        BulkRequestBuilder bulk = this.getClient().prepareBulk();
        elements.forEach(elem -> {
            MetaObject metaObject = this.fieldFactory.build((KObject)elem);
            this.elasticSearchMappingStore.updateMetaModel((KObject)elem, metaObject);
            bulk.add(this.createIndexRequest((ElasticMetaObject)metaObject));
        });
        ((BulkRequestBuilder)bulk.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute().actionGet();
    }

    public IndexRequestBuilder createIndexRequest(ElasticMetaObject object) {
        String clusterId = ((ElasticMetaProperty)object.getProperty("cluster.id").get()).getValue().toLowerCase();
        String type = ((ElasticMetaProperty)object.getProperty("type").get()).getValue().toLowerCase();
        Map<String, Object> document = object.getProperties().stream().map(metaProperty -> (ElasticMetaProperty)metaProperty).collect(Collectors.toMap(ElasticMetaProperty::getName, ElasticMetaProperty::getValue, (mp1, mp2) -> mp2));
        return this.getClient().prepareIndex(this.sanitizeIndex(clusterId), this.sanitizeIndex(type)).setSource(document);
    }

    public boolean exists(String index, String id) {
        return this.findHitsByQuery(Collections.singletonList(index), (Query)new TermQuery(new Term("id", id))) > 0L;
    }

    public void delete(String index) {
        this.getClient().admin().indices().prepareDelete(new String[]{this.sanitizeIndex(index)}).get();
    }

    public void delete(String index, String id) {
        SearchResponse response;
        SearchHit[] hits;
        Optional<SearchResponse> found = this.findByQueryRaw(Collections.singletonList(index), (Query)new TermQuery(new Term("id", id)), null, 1);
        if (found.isPresent() && (hits = (response = found.get()).getHits().getHits()).length > 0) {
            ((DeleteRequestBuilder)this.getClient().prepareDelete(hits[0].getIndex(), hits[0].getType(), hits[0].getId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        }
    }

    public List<KObject> findById(String index, String id) throws IOException {
        return this.findByQuery(Collections.singletonList(index), (Query)new TermQuery(new Term("id", id)), 1);
    }

    public void rename(String index, String id, KObject to) {
        PortablePreconditions.checkNotEmpty((String)"from", (String)index);
        PortablePreconditions.checkNotEmpty((String)"id", (String)id);
        PortablePreconditions.checkNotNull((String)"to", (Object)to);
        PortablePreconditions.checkNotEmpty((String)"clusterId", (String)to.getClusterId());
        PortablePreconditions.checkCondition((String)"renames are allowed only from same cluster", (boolean)to.getClusterId().equals(index));
        if (this.exists(index, id)) {
            this.delete(index, id);
            this.index(to);
        }
    }

    public long getIndexSize(String index) {
        return this.findHitsByQuery(Collections.singletonList(index), (Query)new MatchAllDocsQuery());
    }

    public List<KObject> findByQuery(List<String> indices, Query query, int limit) {
        return this.findByQuery(indices, query, null, limit);
    }

    public List<KObject> findByQuery(List<String> indices, Query query, Sort sort, int limit) {
        Optional<SearchResponse> response = this.findByQueryRaw(indices, query, sort, limit);
        return response.map(this::hitsToKObjects).orElse(Collections.emptyList());
    }

    private List<KObject> hitsToKObjects(SearchResponse response) {
        return Arrays.stream(response.getHits().getHits()).map(searchHit -> this.fieldFactory.fromDocument(searchHit.getSource())).collect(Collectors.toList());
    }

    protected Optional<SearchResponse> findByQueryRaw(List<String> indices, Query query, Sort sort, int limit) {
        try {
            List<String> indexes = indices;
            if (indices.isEmpty()) {
                indexes = this.getIndices();
            }
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)this.escapeSpecialCharacters(query.toString()));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            if (sort != null) {
                Arrays.stream(sort.getSort()).filter(sortField -> sortField.getField() != null).forEach(sortField -> this.addSort(searchSourceBuilder, (SortField)sortField));
            }
            if (limit > 0 && limit <= 10000) {
                searchSourceBuilder.size(limit);
            } else {
                searchSourceBuilder.size(10000);
            }
            return Optional.of(this.getClient().prepareSearch(this.sanitizeIndexes(indexes).toArray(new String[indexes.size()])).setSource(searchSourceBuilder).get());
        }
        catch (ElasticsearchException e) {
            this.logger.debug(MessageFormat.format("Unable to perform search: {0}", e.getMessage()));
            return Optional.empty();
        }
    }

    protected void addSort(SearchSourceBuilder searchSourceBuilder, SortField sortField) {
        String field = sortField.getField();
        searchSourceBuilder.sort(field);
    }

    protected String escapeSpecialCharacters(String queryString) {
        List<String> splittedTokens = Arrays.asList(queryString.split(" "));
        return splittedTokens.stream().map(query -> {
            if (query.chars().filter(ch -> ch == 58).count() >= 0L) {
                int separationChar = query.indexOf(58) + 1;
                return query.substring(0, separationChar) + this.processQuery((String)query, separationChar);
            }
            return query;
        }).collect(Collectors.joining(" "));
    }

    private String processQuery(String query, int separationChar) {
        String queryString = this.escape(query.substring(separationChar));
        if (queryString.contains(":")) {
            queryString = "\"" + queryString + "\"";
        }
        return queryString;
    }

    private String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '!' || c == ':' || c == '^' || c == '\"' || c == '/' || c == '|' || c == '&') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected List<String> sanitizeIndexes(List<String> indices) {
        return indices.stream().map(this::sanitizeIndex).collect(Collectors.toList());
    }

    protected String sanitizeIndex(String index) {
        return index.toLowerCase().replaceAll("/", "_");
    }

    public long findHitsByQuery(List<String> indices, Query query) {
        Optional<SearchResponse> response = this.findByQueryRaw(indices, query, null, 0);
        return response.map(res -> res.getHits().getTotalHits()).orElse(0L);
    }

    public List<String> getIndices() {
        String[] indices = ((GetIndexResponse)this.getClient().admin().indices().prepareGetIndex().get()).getIndices();
        return Arrays.asList(indices).stream().filter(index -> !index.startsWith(".")).collect(Collectors.toList());
    }

    public void putMapping(String index, String type, MetaObject metaObject) {
        PortablePreconditions.checkNotEmpty((String)"index", (String)index);
        PortablePreconditions.checkNotEmpty((String)"type", (String)type);
        PortablePreconditions.checkNotNull((String)"metaObject", (Object)metaObject);
        try {
            this.getClient().admin().indices().prepareCreate(this.sanitizeIndex(index)).get();
        }
        catch (ResourceAlreadyExistsException ex) {
            this.logger.debug("Resource Already exists: " + ex.getMessage());
        }
        Map<String, Object> properties = this.createMappingMap(metaObject.getProperties());
        this.getClient().admin().indices().preparePutMapping(new String[]{this.sanitizeIndex(index)}).setType(this.sanitizeIndex(type)).setSource(properties).get();
    }

    public Optional<MappingMetaData> getMapping(String index, String type) {
        PortablePreconditions.checkNotEmpty((String)"index", (String)index);
        PortablePreconditions.checkNotEmpty((String)"type", (String)type);
        try {
            GetMappingsResponse mappingResponse = (GetMappingsResponse)((GetMappingsRequestBuilder)this.getClient().admin().indices().prepareGetMappings(new String[]{this.sanitizeIndex(index)}).addTypes(new String[]{this.sanitizeIndex(type)})).get();
            return Optional.ofNullable(((ImmutableOpenMap)mappingResponse.getMappings().getOrDefault((Object)this.sanitizeIndex(index), (Object)ImmutableOpenMap.of())).getOrDefault((Object)this.sanitizeIndex(type), null));
        }
        catch (IndexNotFoundException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(MessageFormat.format("Index not found trying to get mapping for {0}:{1}", index, type), (Throwable)ex);
            }
            return Optional.empty();
        }
    }

    public void putMapping(String index, String type, List<MetaProperty> metaProperties) {
        PortablePreconditions.checkNotEmpty((String)"index", (String)index);
        PortablePreconditions.checkNotEmpty((String)"type", (String)type);
        Map<String, Object> properties = this.createMappingMap(metaProperties);
        this.getClient().admin().indices().preparePutMapping(new String[]{this.sanitizeIndex(index)}).setType(this.sanitizeIndex(type)).setSource(properties).get();
    }

    private Map<String, Object> createMappingMap(Collection<MetaProperty> metaProperties) {
        PortablePreconditions.checkNotNull((String)"metaProperties", metaProperties);
        HashMap properties = new HashMap();
        metaProperties.forEach(metaProperty -> {
            ElasticMetaProperty elasticProperty = (ElasticMetaProperty)metaProperty;
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("type", this.createElasticType(elasticProperty));
            this.createAnalyzerField(configuration, elasticProperty);
            properties.put(metaProperty.getName(), configuration);
        });
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("properties", properties);
        return mapping;
    }

    private void createAnalyzerField(Map<String, String> configuration, ElasticMetaProperty elasticProperty) {
        if (this.analyzer instanceof ElasticSearchAnalyzerWrapper) {
            Class<?> type = elasticProperty.getTypes().iterator().next();
            if (type == String.class && elasticProperty.isSearchable()) {
                ElasticSearchAnalyzerWrapper elasticSearchAnalyzerWrapper = (ElasticSearchAnalyzerWrapper)this.analyzer;
                configuration.put("analyzer", elasticSearchAnalyzerWrapper.getFieldAnalyzer(elasticProperty.getName()));
            }
        } else {
            throw new IllegalArgumentException("ElasticSearchAnalyzerWrapper is expected to be compatible with Elasticsearch");
        }
    }

    protected String createElasticType(MetaProperty metaProperty) {
        Class type = (Class)metaProperty.getTypes().iterator().next();
        if (type == String.class && metaProperty.isSearchable()) {
            return ES_TEXT_TYPE;
        }
        if (type == String.class && !metaProperty.isSearchable()) {
            return ES_KEYWORD_TYPE;
        }
        return type.getSimpleName().toLowerCase();
    }

    public void dispose() {
        this.metaModelStore.dispose();
    }
}

