/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.pillar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultPillarSelector
extends AbstractSelector
implements PillarSelector,
SelectionCacheLifecycleListener {
    protected static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    protected final EntitySelector entitySelector;
    protected final Collection<GenuineVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;
    protected final boolean subPillarEnabled;
    protected final int minimumSubPillarSize;
    protected final int maximumSubPillarSize;
    protected List<List<Object>> cachedBasePillarList = null;

    public DefaultPillarSelector(EntitySelector entitySelector, Collection<GenuineVariableDescriptor> variableDescriptors, boolean randomSelection, boolean subPillarEnabled, int minimumSubPillarSize, int maximumSubPillarSize) {
        this.entitySelector = entitySelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        Class<?> entityClass = entitySelector.getEntityDescriptor().getEntityClass();
        for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!entityClass.equals(variableDescriptor.getEntityDescriptor().getEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal to the entitySelector's entityClass (" + entityClass + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") cannot have a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        if (entitySelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has an entitySelector (" + entitySelector + ") with neverEnding (" + entitySelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
        this.subPillarEnabled = subPillarEnabled;
        this.minimumSubPillarSize = minimumSubPillarSize;
        this.maximumSubPillarSize = maximumSubPillarSize;
        if (minimumSubPillarSize < 1) {
            throw new IllegalStateException("The selector (" + this + ")'s minimumPillarSize (" + minimumSubPillarSize + ") must be at least 1.");
        }
        if (minimumSubPillarSize > maximumSubPillarSize) {
            throw new IllegalStateException("The minimumPillarSize (" + minimumSubPillarSize + ") must be at least maximumSubChainSize (" + maximumSubPillarSize + ").");
        }
        if (!randomSelection && subPillarEnabled) {
            throw new IllegalStateException("The selector (" + this + ") with randomSelection  (" + randomSelection + ") and subPillarEnabled (" + subPillarEnabled + ") does not support non random selection with sub pillars because the number of sub pillars scales exponentially.\nEither set subPillarEnabled to false or use JIT random selection.");
        }
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        return this.entitySelector.getEntityDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has an entitySelector (" + this.entitySelector + ") with entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        LinkedHashMap<List, List> valueStateToPillarMap = new LinkedHashMap<List, List>((int)entitySize);
        for (Object entity : this.entitySelector) {
            ArrayList<Object> valueState = new ArrayList<Object>(this.variableDescriptors.size());
            for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
                Object value = variableDescriptor.getValue(entity);
                valueState.add(value);
            }
            List pillar = valueStateToPillarMap.computeIfAbsent(valueState, key -> new ArrayList());
            pillar.add(entity);
        }
        this.cachedBasePillarList = new ArrayList(valueStateToPillarMap.values());
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedBasePillarList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        if (!this.subPillarEnabled) {
            return this.cachedBasePillarList.size();
        }
        throw new UnsupportedOperationException("The selector (" + this + ") with randomSelection  (" + this.randomSelection + ") and subPillarEnabled (" + this.subPillarEnabled + ") does not support getSize() because the number of sub pillars scales exponentially.");
    }

    @Override
    public Iterator<List<Object>> iterator() {
        if (!this.randomSelection) {
            if (!this.subPillarEnabled) {
                return this.cachedBasePillarList.iterator();
            }
            throw new IllegalStateException("Impossible state because the constructors fails with randomSelection (" + this.randomSelection + ") and subPillarEnabled (" + this.subPillarEnabled + ").");
        }
        if (!this.subPillarEnabled) {
            return new CachedListRandomIterator<List<Object>>(this.cachedBasePillarList, this.workingRandom);
        }
        return new RandomSubPillarIterator();
    }

    @Override
    public ListIterator<List<Object>> listIterator() {
        if (!this.randomSelection) {
            if (!this.subPillarEnabled) {
                return this.cachedBasePillarList.listIterator();
            }
            throw new IllegalStateException("Impossible state because the constructors fails with randomSelection (" + this.randomSelection + ") and subPillarEnabled (" + this.subPillarEnabled + ").");
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<List<Object>> listIterator(int index) {
        if (!this.randomSelection) {
            if (!this.subPillarEnabled) {
                return this.cachedBasePillarList.listIterator(index);
            }
            throw new IllegalStateException("Impossible state because the constructors fails with randomSelection (" + this.randomSelection + ") and subPillarEnabled (" + this.subPillarEnabled + ").");
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ")";
    }

    private class RandomSubPillarIterator
    extends UpcomingSelectionIterator<List<Object>> {
        public RandomSubPillarIterator() {
            if (DefaultPillarSelector.this.cachedBasePillarList.isEmpty()) {
                this.upcomingSelection = this.noUpcomingSelection();
                this.upcomingCreated = true;
            }
        }

        @Override
        protected List<Object> createUpcomingSelection() {
            List<Object> basePillar = this.selectBasePillar();
            int basePillarSize = basePillar.size();
            if (basePillarSize == 1) {
                return basePillar;
            }
            int min = Math.min(DefaultPillarSelector.this.minimumSubPillarSize, basePillarSize);
            int max = Math.min(DefaultPillarSelector.this.maximumSubPillarSize, basePillarSize);
            int subPillarSize = min + DefaultPillarSelector.this.workingRandom.nextInt(max - min + 1);
            if (subPillarSize == basePillarSize) {
                return basePillar;
            }
            if (subPillarSize == 1) {
                int randomIndex = DefaultPillarSelector.this.workingRandom.nextInt(basePillarSize);
                Object randomElement = basePillar.get(randomIndex);
                return Collections.singletonList(randomElement);
            }
            return IntStream.generate(() -> DefaultPillarSelector.this.workingRandom.nextInt(basePillarSize)).distinct().limit(subPillarSize).mapToObj(basePillar::get).collect(Collectors.toCollection(() -> new ArrayList(subPillarSize)));
        }

        private List<Object> selectBasePillar() {
            int baseListIndex = DefaultPillarSelector.this.workingRandom.nextInt(DefaultPillarSelector.this.cachedBasePillarList.size());
            return DefaultPillarSelector.this.cachedBasePillarList.get(baseListIndex);
        }
    }
}

