/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;

public class AssociationList {
    private final List<AssociationDeclaration> inputs;
    private final List<AssociationDeclaration> outputs;

    public AssociationList(List<AssociationDeclaration> inputs, List<AssociationDeclaration> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public AssociationList(List<AssociationDeclaration> all) {
        this.inputs = new ArrayList<AssociationDeclaration>();
        this.outputs = new ArrayList<AssociationDeclaration>();
        for (AssociationDeclaration associationDeclaration : all) {
            if (associationDeclaration.getDirection() == AssociationDeclaration.Direction.Input) {
                this.inputs.add(associationDeclaration);
                continue;
            }
            this.outputs.add(associationDeclaration);
        }
    }

    public AssociationList() {
        this.inputs = new ArrayList<AssociationDeclaration>();
        this.outputs = new ArrayList<AssociationDeclaration>();
    }

    public static AssociationList fromString(String encoded) {
        if (encoded.isEmpty()) {
            return new AssociationList();
        }
        return new AssociationList(Arrays.stream(encoded.split(",")).map(AssociationDeclaration::fromString).collect(Collectors.toList()));
    }

    public List<AssociationDeclaration> getInputs() {
        return this.inputs;
    }

    public AssociationDeclaration lookupInput(String id) {
        return this.inputs.stream().filter(in -> in.getTarget().equals(id)).findFirst().orElse(null);
    }

    public AssociationDeclaration lookupOutput(String id) {
        return this.outputs.stream().filter(in -> in.getSource().equals(id)).findFirst().orElse(null);
    }

    public List<AssociationDeclaration> getOutputs() {
        return this.outputs;
    }

    public String toString() {
        return Stream.concat(this.inputs.stream(), this.outputs.stream()).map(AssociationDeclaration::toString).collect(Collectors.joining(","));
    }
}

