/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.Objects;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;

public class VariableDeclaration {
    private final ItemDefinition typeDeclaration;
    private final Property typedIdentifier;
    private String identifier;
    private String type;

    public VariableDeclaration(String identifier, String type) {
        this.setIdentifier(identifier);
        this.type = type;
        this.typeDeclaration = Factories.bpmn2.createItemDefinition();
        this.typeDeclaration.setId(Ids.item(this.getIdentifier()));
        this.typeDeclaration.setStructureRef(type);
        this.typedIdentifier = Factories.bpmn2.createProperty();
        this.typedIdentifier.setId(Ids.typedIdentifier("GLOBAL", this.getIdentifier()));
        this.typedIdentifier.setName(identifier);
        this.typedIdentifier.setItemSubjectRef(this.typeDeclaration);
    }

    public static VariableDeclaration fromString(String encoded) {
        String type;
        String[] split = encoded.split(":");
        String identifier = split[0];
        String string = type = split.length == 2 ? split[1] : "";
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Variable identifier cannot be empty. Given: '" + encoded + "'");
        }
        return new VariableDeclaration(identifier, type);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        String safeIdentifier;
        this.identifier = safeIdentifier = identifier.replaceAll(" ", "-");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ItemDefinition getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public Property getTypedIdentifier() {
        return this.typedIdentifier;
    }

    public String toString() {
        if (this.type == null || this.type.isEmpty()) {
            return this.typedIdentifier.getName();
        }
        return this.typedIdentifier.getName() + ":" + this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDeclaration that = (VariableDeclaration)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.type);
    }
}

