/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events;

import java.util.List;
import org.eclipse.bpmn2.CancelEventDefinition;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.TerminateEventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventDefinitionReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ThrowEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.EndCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndTerminateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.ActivityRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.ScopedSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class EndEventConverter {
    private final TypedFactoryManager factoryManager;
    private final PropertyReaderFactory propertyReaderFactory;

    public EndEventConverter(TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    public BpmnNode convert(EndEvent event) {
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        List<EventDefinition> eventDefinitions = p.getEventDefinitions();
        switch (eventDefinitions.size()) {
            case 0: {
                return this.endNoneEvent(event);
            }
            case 1: {
                return Match.of(EventDefinition.class, BpmnNode.class).when(TerminateEventDefinition.class, e -> this.terminateEndEvent(event, (TerminateEventDefinition)e)).when(SignalEventDefinition.class, e -> this.signalEventDefinition(event, (SignalEventDefinition)e)).when(MessageEventDefinition.class, e -> this.messageEventDefinition(event, (MessageEventDefinition)e)).when(ErrorEventDefinition.class, e -> this.errorEventDefinition(event, (ErrorEventDefinition)e)).when(EscalationEventDefinition.class, e -> this.escalationEventDefinition(event, (EscalationEventDefinition)e)).when(CompensateEventDefinition.class, e -> this.compensationEventDefinition(event, (CompensateEventDefinition)e)).missing(CancelEventDefinition.class).apply(eventDefinitions.get(0)).value();
            }
        }
        throw new UnsupportedOperationException("Multiple event definitions not supported for end event");
    }

    private BpmnNode messageEventDefinition(EndEvent event, MessageEventDefinition e) {
        Node node = this.factoryManager.newNode(event.getId(), EndMessageEvent.class);
        EndMessageEvent definition = (EndMessageEvent)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(((EventPropertyReader)p).getAssignmentsInfo()));
        definition.setExecutionSet(new MessageEventExecutionSet(new MessageRef(EventDefinitionReader.messageRefOf(e))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode signalEventDefinition(EndEvent event, SignalEventDefinition nodeId) {
        Node node = this.factoryManager.newNode(event.getId(), EndSignalEvent.class);
        EndSignalEvent definition = (EndSignalEvent)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(((EventPropertyReader)p).getAssignmentsInfo()));
        definition.setExecutionSet(new ScopedSignalEventExecutionSet(new SignalRef(p.getSignalRef()), new SignalScope(p.getSignalScope())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode terminateEndEvent(EndEvent event, TerminateEventDefinition e) {
        Node node = this.factoryManager.newNode(event.getId(), EndTerminateEvent.class);
        EndTerminateEvent definition = (EndTerminateEvent)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode endNoneEvent(EndEvent event) {
        Node node = this.factoryManager.newNode(event.getId(), EndNoneEvent.class);
        EndNoneEvent definition = (EndNoneEvent)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode errorEventDefinition(EndEvent event, ErrorEventDefinition e) {
        Node node = this.factoryManager.newNode(event.getId(), EndErrorEvent.class);
        EndErrorEvent definition = (EndErrorEvent)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(((EventPropertyReader)p).getAssignmentsInfo()));
        definition.setExecutionSet(new ErrorEventExecutionSet(new ErrorRef(EventDefinitionReader.errorRefOf(e))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode escalationEventDefinition(EndEvent event, EscalationEventDefinition e) {
        Node node = this.factoryManager.newNode(event.getId(), EndEscalationEvent.class);
        EndEscalationEvent definition = (EndEscalationEvent)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(((EventPropertyReader)p).getAssignmentsInfo()));
        definition.setExecutionSet(new EscalationEventExecutionSet(new EscalationRef(EventDefinitionReader.escalationRefOf(e))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode compensationEventDefinition(EndEvent event, CompensateEventDefinition eventDefinition) {
        Node node = this.factoryManager.newNode(event.getId(), EndCompensationEvent.class);
        EndCompensationEvent definition = (EndCompensationEvent)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new CompensationEventExecutionSet(new ActivityRef(EventDefinitionReader.activityRefOf(eventDefinition))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }
}

