/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CaseFileVariableReader;

class ProcessVariableReader {
    ProcessVariableReader() {
    }

    static String getProcessVariables(List<Property> properties) {
        return properties.stream().filter(ProcessVariableReader::isProcessVariable).map(ProcessVariableReader::toProcessVariableString).collect(Collectors.joining(","));
    }

    private static String toProcessVariableString(Property p) {
        String processVariableName = ProcessVariableReader.getProcessVariableName(p);
        return Optional.ofNullable(p.getItemSubjectRef()).map(ItemDefinition::getStructureRef).map(type -> processVariableName + ":" + type).orElse(processVariableName);
    }

    public static String getProcessVariableName(Property p) {
        String name = p.getName();
        return name == null ? p.getId() : name;
    }

    public static boolean isProcessVariable(Property p) {
        return !CaseFileVariableReader.isCaseFileVariable(p);
    }
}

