/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.sequenceflows;

import java.util.Map;
import org.eclipse.bpmn2.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SequenceFlowPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.common.ConditionExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.connectors.Priority;
import org.kie.workbench.common.stunner.bpmn.definition.property.connectors.SequenceFlowExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class SequenceFlowConverter {
    private final PropertyReaderFactory propertyReaderFactory;
    private TypedFactoryManager factoryManager;

    public SequenceFlowConverter(TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    public BpmnEdge convertEdge(SequenceFlow seq, Map<String, BpmnNode> nodes) {
        Edge edge = this.factoryManager.newEdge(seq.getId(), org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow.class);
        org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow definition = (org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow)((View)edge.getContent()).getDefinition();
        SequenceFlowPropertyReader p = this.propertyReaderFactory.of(seq);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new SequenceFlowExecutionSet(new Priority(p.getPriority()), new ConditionExpression(p.getConditionExpression())));
        return BpmnEdge.of(edge, nodes.get(p.getSourceId()), p.getSourceConnection(), p.getControlPoints(), nodes.get(p.getTargetId()), p.getTargetConnection(), p);
    }
}

