/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.dataproviders;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.forms.dynamic.model.config.SelectorData;
import org.kie.workbench.common.forms.dynamic.model.config.SelectorDataProvider;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindRuleFlowNamesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;

public class RuleFlowGroupFormProvider
implements SelectorDataProvider {
    private final RefactoringQueryService queryService;
    private final Function<List<RefactoringPageRow>, TreeMap> resultToSelectorData;
    public static Function<List<RefactoringPageRow>, TreeMap> DEFAULT_RESULT_CONVERTER = rows -> rows.stream().map(RuleFlowGroupFormProvider::getValue).filter(RuleFlowGroupFormProvider::isNotEmpty).collect(Collectors.toMap(name -> name, name -> name, (oldValue, newValue) -> oldValue, TreeMap::new));

    protected RuleFlowGroupFormProvider() {
        this(null, null);
    }

    @Inject
    public RuleFlowGroupFormProvider(RefactoringQueryService queryService) {
        this(queryService, DEFAULT_RESULT_CONVERTER);
    }

    RuleFlowGroupFormProvider(RefactoringQueryService queryService, Function<List<RefactoringPageRow>, TreeMap> resultToSelectorData) {
        this.queryService = queryService;
        this.resultToSelectorData = resultToSelectorData;
    }

    public String getProviderName() {
        return this.getClass().getSimpleName();
    }

    public SelectorData getSelectorData(FormRenderingContext context) {
        return new SelectorData(this.getRuleFlowGroupNames(), null);
    }

    private Map<Object, String> getRuleFlowGroupNames() {
        List queryResult = this.queryService.query(FindRuleFlowNamesQuery.NAME, new Sets.Builder().add((Object)new ValueSharedPartIndexTerm("*", PartType.RULEFLOW_GROUP, ValueIndexTerm.TermSearchType.WILDCARD)).build());
        return this.resultToSelectorData.apply(queryResult);
    }

    private static String getValue(RefactoringPageRow row) {
        return (String)((Map)row.getValue()).get("name");
    }

    private static boolean isNotEmpty(String s) {
        return null != s && s.trim().length() > 0;
    }
}

