/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama;

import java.util.HashMap;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.HasBounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.processing.layout.AbstractLayoutService;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Layout;
import org.kie.workbench.common.stunner.core.graph.processing.layout.ReorderedGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.VertexPositionImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.LayeredGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step01.CycleBreaker;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step02.VertexLayerer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.VertexOrdering;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step04.LayerArrangement;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step04.VertexPositioning;

@Default
public final class SugiyamaLayoutService
extends AbstractLayoutService {
    private final CycleBreaker cycleBreaker;
    private final VertexLayerer vertexLayerer;
    private final VertexOrdering vertexOrdering;
    private final VertexPositioning vertexPositioning;

    @Inject
    public SugiyamaLayoutService(CycleBreaker cycleBreaker, VertexLayerer vertexLayerer, VertexOrdering vertexOrdering, VertexPositioning vertexPositioning) {
        this.cycleBreaker = cycleBreaker;
        this.vertexLayerer = vertexLayerer;
        this.vertexOrdering = vertexOrdering;
        this.vertexPositioning = vertexPositioning;
    }

    @Override
    public Layout createLayout(Graph<?, ?> graph) {
        HashMap<String, Node> indexByUuid = new HashMap<String, Node>();
        LayeredGraph reorderedGraph = new LayeredGraph();
        for (Node n : graph.nodes()) {
            Edge edge;
            if (!(n.getContent() instanceof HasBounds)) continue;
            indexByUuid.put(n.getUUID(), n);
            for (Object e : n.getInEdges()) {
                if (!(e instanceof Edge)) continue;
                edge = (Edge)e;
                String from = edge.getSourceNode().getUUID();
                String to = n.getUUID();
                reorderedGraph.addEdge(from, to);
            }
            for (Object e : n.getOutEdges()) {
                if (!(e instanceof Edge)) continue;
                edge = (Edge)e;
                String to = edge.getTargetNode().getUUID();
                String from = n.getUUID();
                reorderedGraph.addEdge(from, to);
            }
        }
        this.cycleBreaker.breakCycle((ReorderedGraph)reorderedGraph);
        this.vertexLayerer.createLayers((ReorderedGraph)reorderedGraph);
        this.vertexOrdering.orderVertices((ReorderedGraph)reorderedGraph);
        this.vertexPositioning.calculateVerticesPositions((ReorderedGraph)reorderedGraph, LayerArrangement.BottomUp);
        List<GraphLayer> orderedLayers = reorderedGraph.getLayers();
        return this.buildLayout(indexByUuid, orderedLayers);
    }

    private Layout buildLayout(HashMap<String, Node> indexByUuid, List<GraphLayer> layers) {
        Layout layout = new Layout();
        for (int i = layers.size() - 1; i >= 0; --i) {
            GraphLayer layer = layers.get(i);
            for (Vertex v : layer.getVertices()) {
                Node n = indexByUuid.get(v.getId());
                int x = v.getX();
                int y = v.getY();
                Bounds currentBounds = ((HasBounds)n.getContent()).getBounds();
                Bound lowerRight = currentBounds.getLowerRight();
                int x2 = SugiyamaLayoutService.isCloseToZero(lowerRight.getX()) ? x + 100 : (int)((double)x + lowerRight.getX());
                int y2 = SugiyamaLayoutService.isCloseToZero(lowerRight.getY()) ? y + 50 : (int)((double)y + lowerRight.getY());
                VertexPositionImpl position = new VertexPositionImpl(v.getId(), new Point2D((double)x, (double)y), new Point2D((double)x2, (double)y2));
                layout.getNodePositions().add(position);
            }
        }
        return layout;
    }
}

