/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.marshaller;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;

@Portable
public class MarshallingMessage
implements DomainViolation {
    private final String elementUUID;
    private final int code;
    private final Violation.Type type;
    private final String message;
    private final String messageKey;
    private final List<?> messageArguments;

    public String getUUID() {
        return this.elementUUID;
    }

    public String getMessage() {
        return this.message;
    }

    public Violation.Type getViolationType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public List<?> getMessageArguments() {
        return this.messageArguments;
    }

    public MarshallingMessage(@MapsTo(value="elementUUID") String elementUUID, @MapsTo(value="code") int code, @MapsTo(value="type") Violation.Type type, @MapsTo(value="message") String message, @MapsTo(value="messageKey") String messageKey, @MapsTo(value="messageArguments") List<?> messageArguments) {
        this.elementUUID = elementUUID;
        this.code = code;
        this.type = type;
        this.message = message;
        this.messageKey = messageKey;
        this.messageArguments = messageArguments;
    }

    public static MarshallingMessageBuilder builder() {
        return new MarshallingMessageBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshallingMessage that = (MarshallingMessage)o;
        return this.code == that.code && Objects.equals(this.elementUUID, that.elementUUID) && this.type == that.type && Objects.equals(this.message, that.message) && Objects.equals(this.messageKey, that.messageKey) && Objects.equals(this.messageArguments, that.messageArguments);
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{Objects.hashCode(this.getUUID()), Objects.hashCode(this.getCode()), Objects.hashCode(this.type), Objects.hashCode(this.getMessage()), Objects.hashCode(this.getMessageKey()), Objects.hashCode(this.getMessageArguments())});
    }

    public String toString() {
        return "MarshallingMessage{elementUUID='" + this.elementUUID + '\'' + ", code=" + this.code + ", type=" + this.type + ", message='" + this.message + '\'' + ", messageKey='" + this.messageKey + '\'' + ", messageArguments=" + this.messageArguments + '}';
    }

    public static class MarshallingMessageBuilder {
        private String elementUUID;
        private int code;
        private Violation.Type type = Violation.Type.ERROR;
        private String message;
        private String messageKey;
        private List<?> messageArguments = Collections.emptyList();

        public MarshallingMessageBuilder elementUUID(String elementUUID) {
            this.elementUUID = elementUUID;
            return this;
        }

        public MarshallingMessageBuilder code(int code) {
            this.code = code;
            return this;
        }

        public MarshallingMessageBuilder type(Violation.Type type) {
            this.type = type;
            return this;
        }

        public MarshallingMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public MarshallingMessageBuilder messageKey(String messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        public MarshallingMessageBuilder messageArguments(List<?> messageArguments) {
            this.messageArguments = messageArguments;
            return this;
        }

        public MarshallingMessage build() {
            return new MarshallingMessage(this.elementUUID, this.code, this.type, this.message, this.messageKey, this.messageArguments);
        }
    }
}

