/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.error;

import com.google.gwt.user.client.Window;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.exception.DataSetLookupException;
import org.jboss.errai.bus.client.api.InvalidBusContentException;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.workbench.common.workbench.client.entrypoint.GenericErrorPopup;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

@Dependent
public class DefaultWorkbenchErrorCallback {
    @Inject
    private GenericErrorPopup genericErrorPopup;

    public static boolean isKieServerForbiddenException(Throwable throwable) {
        if (throwable instanceof KieServicesHttpException && ((KieServicesHttpException)throwable).getHttpCode() == 403) {
            return true;
        }
        return throwable instanceof DataSetLookupException && throwable.getCause() != null && throwable.getCause().getMessage().contains("Error code: 403");
    }

    public static boolean isKieServerUnauthorizedException(Throwable throwable) {
        if (throwable instanceof KieServicesHttpException && ((KieServicesHttpException)throwable).getHttpCode() == 401) {
            return true;
        }
        return throwable instanceof DataSetLookupException && throwable.getCause() != null && throwable.getCause().getMessage().contains("Error code: 401");
    }

    public static boolean isInvalidBusContentException(Throwable throwable) {
        return throwable instanceof InvalidBusContentException;
    }

    public void error(Throwable throwable) {
        if (DefaultWorkbenchErrorCallback.isInvalidBusContentException(throwable)) {
            YesNoCancelPopup result = YesNoCancelPopup.newYesNoCancelPopup((String)DefaultWorkbenchConstants.INSTANCE.SessionTimeout(), (String)DefaultWorkbenchConstants.INSTANCE.InvalidBusResponseProbablySessionTimeout(), Window.Location::reload, null, () -> {});
            result.clearScrollHeight();
            result.show();
            return;
        }
        if (DefaultWorkbenchErrorCallback.isKieServerForbiddenException(throwable)) {
            ErrorPopup.showMessage((String)DefaultWorkbenchConstants.INSTANCE.KieServerError403());
            return;
        }
        if (DefaultWorkbenchErrorCallback.isKieServerUnauthorizedException(throwable)) {
            ErrorPopup.showMessage((String)DefaultWorkbenchConstants.INSTANCE.KieServerError401());
            return;
        }
        if (throwable instanceof DataSetLookupException) {
            DataSetLookupException ex = (DataSetLookupException)throwable;
            ErrorPopup.showMessage((String)CommonConstants.INSTANCE.ExceptionGeneric0(ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage()));
            return;
        }
        if (throwable instanceof KieServicesHttpException) {
            KieServicesHttpException ex = (KieServicesHttpException)throwable;
            ErrorPopup.showMessage((String)CommonConstants.INSTANCE.ExceptionGeneric0(ex.getExceptionMessage()));
            return;
        }
        if (throwable instanceof KieServicesException) {
            KieServicesException ex = (KieServicesException)throwable;
            ErrorPopup.showMessage((String)CommonConstants.INSTANCE.ExceptionGeneric0(ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage()));
            return;
        }
        this.genericErrorPopup.show();
        this.genericErrorPopup.setup("Uncaught exception: " + this.extractMessageRecursively(throwable));
    }

    private String extractMessageRecursively(Throwable t) {
        if (t.getCause() == null) {
            return t.getMessage();
        }
        return t.getMessage() + " Caused by: " + this.extractMessageRecursively(t.getCause());
    }
}

