/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.FieldQueryExtension;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;

public class ExistsFieldQueryExtension
implements FieldQueryExtension {
    public static final String NAME = "_exists_";

    @Override
    public Query query(QueryShardContext context, String queryText) {
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)context.getMapperService().fullName("_field_names");
        if (fieldNamesFieldType == null) {
            return new MatchNoDocsQuery("No mappings yet");
        }
        if (!fieldNamesFieldType.isEnabled()) {
            return new WildcardQuery(new Term(queryText, "*"));
        }
        return ExistsQueryBuilder.newFilter(context, queryText);
    }
}

