/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.v1_2.TImport;
import org.kie.workbench.common.dmn.api.definition.v1_1.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.v1_1.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.QNamePropertyConverter;

public final class ImportConverter {
    public static org.kie.workbench.common.dmn.api.definition.v1_1.Import wbFromDMN(Import dmn, Definitions definitions, PMMLDocumentMetadata pmmlDocument) {
        org.kie.workbench.common.dmn.api.definition.v1_1.Import result = ImportConverter.createWBImport(dmn, definitions, pmmlDocument);
        HashMap additionalAttributes = new HashMap();
        for (Map.Entry entry : dmn.getAdditionalAttributes().entrySet()) {
            additionalAttributes.put(QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)entry.getKey(), (DMNModelInstrumentedBase)dmn), entry.getValue());
        }
        result.setAdditionalAttributes(additionalAttributes);
        String id = dmn.getId();
        String name = dmn.getName();
        String description = dmn.getDescription();
        result.setId(new Id(id != null ? id : UUID.randomUUID().toString()));
        result.setName(new Name(name));
        result.setDescription(DescriptionPropertyConverter.wbFromDMN(description));
        dmn.getNsContext().forEach((key, value) -> result.getNsContext().put(key, value));
        return result;
    }

    private static org.kie.workbench.common.dmn.api.definition.v1_1.Import createWBImport(Import dmn, Definitions definitions, PMMLDocumentMetadata pmmlDocument) {
        LocationURI locationURI = new LocationURI(dmn.getLocationURI());
        if (Objects.equals(DMNImportTypes.DMN, DMNImportTypes.determineImportType((String)dmn.getImportType()))) {
            ImportDMN result = new ImportDMN(dmn.getNamespace(), locationURI, dmn.getImportType());
            result.setDrgElementsCount(ImportConverter.countDefinitionElement(definitions, () -> d -> d.getDrgElement().size()).intValue());
            result.setItemDefinitionsCount(ImportConverter.countDefinitionElement(definitions, () -> d -> d.getItemDefinition().size()).intValue());
            return result;
        }
        if (Objects.equals(DMNImportTypes.PMML, DMNImportTypes.determineImportType((String)dmn.getImportType()))) {
            ImportPMML result = new ImportPMML(dmn.getNamespace(), locationURI, dmn.getImportType());
            result.setModelCount(pmmlDocument.getModels().size());
            return result;
        }
        return new org.kie.workbench.common.dmn.api.definition.v1_1.Import(dmn.getNamespace(), locationURI, dmn.getImportType());
    }

    public static Import dmnFromWb(org.kie.workbench.common.dmn.api.definition.v1_1.Import wb) {
        TImport result = new TImport();
        result.setImportType(wb.getImportType());
        result.setLocationURI(wb.getLocationURI().getValue());
        result.setNamespace(wb.getNamespace());
        HashMap additionalAttributes = new HashMap();
        for (Map.Entry entry : wb.getAdditionalAttributes().entrySet()) {
            QNamePropertyConverter.dmnFromWB((QName)entry.getKey()).ifPresent(qName -> {
                String cfr_ignored_0 = (String)additionalAttributes.put(qName, entry.getValue());
            });
        }
        result.setId(wb.getId().getValue());
        result.setName(wb.getName().getValue());
        result.setDescription(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        result.setAdditionalAttributes(additionalAttributes);
        wb.getNsContext().forEach((arg_0, arg_1) -> ImportConverter.lambda$dmnFromWb$6((Import)result, arg_0, arg_1));
        return result;
    }

    private static Integer countDefinitionElement(Definitions definitions, Supplier<Function<Definitions, Integer>> supplier) {
        Integer none = 0;
        return Optional.ofNullable(definitions).map(supplier.get()).orElse(none);
    }

    private static /* synthetic */ void lambda$dmnFromWb$6(Import result, String key, String value) {
        result.getNsContext().put(key, value);
    }
}

