/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.IsWidget;
import elemental2.promise.Promise;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.EditorTitle;
import org.uberfire.ext.editor.commons.client.event.ConcurrentDeleteAcceptedEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentDeleteIgnoredEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameAcceptedEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameIgnoredEvent;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItemBuilder;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class BaseEditor<T, M> {
    protected boolean isReadOnly;
    protected BaseEditorView baseView;
    protected ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = null;
    protected Menus menus;
    protected Promise<Void> makeMenuBarPromise;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    protected Event<ChangeTitleWidgetEvent> changeTitleNotification;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected VersionRecordManager versionRecordManager;
    @Inject
    protected ManagedInstance<BasicFileMenuBuilder> menuBuilderManagedInstance;
    @Inject
    protected BasicFileMenuBuilder menuBuilder;
    @Inject
    protected DefaultFileNameValidator fileNameValidator;
    @Inject
    protected SaveAndRenameCommandBuilder<T, M> saveAndRenameCommandBuilder;
    @Inject
    protected Event<ConcurrentDeleteAcceptedEvent> concurrentDeleteAcceptedEvent;
    @Inject
    protected Event<ConcurrentDeleteIgnoredEvent> concurrentDeleteIgnoredEvent;
    @Inject
    protected Event<ConcurrentRenameAcceptedEvent> concurrentRenameAcceptedEvent;
    @Inject
    protected Event<ConcurrentRenameIgnoredEvent> concurrentRenameIgnoredEvent;
    @Inject
    private DownloadMenuItemBuilder downloadMenuItemBuilder;
    @Inject
    protected Promises promises;
    @Inject
    protected DeletePopUpPresenter deletePopUpPresenter;
    protected Set<MenuItems> menuItems = new HashSet<MenuItems>();
    protected PlaceRequest place;
    protected ClientResourceType type;
    protected Integer originalHash;
    protected Integer metadataOriginalHash;
    protected boolean isValidationRunning = false;
    private boolean displayShowMoreVersions;
    private ObservablePath path;

    BaseEditor(VersionRecordManager versionRecordManager, BaseEditorView baseView, BasicFileMenuBuilder menuBuilder, Event<ChangeTitleWidgetEvent> changeTitleNotification) {
        this.versionRecordManager = versionRecordManager;
        this.baseView = baseView;
        this.menuBuilder = menuBuilder;
        this.changeTitleNotification = changeTitleNotification;
    }

    protected BaseEditor() {
    }

    protected BaseEditor(BaseEditorView baseView) {
        this.baseView = baseView;
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, MenuItems ... menuItems) {
        this.init(path, place, type, true, false, menuItems);
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, boolean addFileChangeListeners, boolean displayShowMoreVersions, MenuItems ... menuItems) {
        this.init(path, place, type, addFileChangeListeners, displayShowMoreVersions, Arrays.asList(menuItems));
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, boolean addFileChangeListeners, boolean displayShowMoreVersions, Collection<MenuItems> menuItems) {
        this.path = path;
        this.place = place;
        this.type = type;
        this.menuItems.addAll(menuItems);
        this.displayShowMoreVersions = displayShowMoreVersions;
        this.baseView.showLoading();
        this.isReadOnly = this.place.getParameter("readOnly", null) != null;
        this.versionRecordManager.init(this.place.getParameter("version", null), path, (Callback<VersionRecord>)((Callback)this::selectVersion));
        if (displayShowMoreVersions) {
            this.versionRecordManager.setShowMoreCommand(new Command(){

                public void execute() {
                    BaseEditor.this.showVersions();
                }
            });
        }
        if (addFileChangeListeners) {
            this.addFileChangeListeners(path);
        }
        this.getMenus(menus -> this.loadContent());
        this.concurrentUpdateSessionInfo = null;
    }

    protected void showVersions() {
    }

    protected Promise<Void> makeMenuBar() {
        if (this.menuItems.contains((Object)MenuItems.SAVE)) {
            this.menuBuilder.addSave(this.getOnSave());
        }
        if (this.menuItems.contains((Object)MenuItems.COPY)) {
            this.menuBuilder.addCopy((Path)this.versionRecordManager.getCurrentPath(), this.getCopyValidator(), this.getCopyServiceCaller());
        }
        if (this.menuItems.contains((Object)MenuItems.RENAME)) {
            this.menuBuilder.addRename(this.getSaveAndRename());
        }
        if (this.menuItems.contains((Object)MenuItems.DELETE)) {
            this.menuBuilder.addDelete((Path)this.versionRecordManager.getCurrentPath(), this.getDeleteServiceCaller());
        }
        if (this.menuItems.contains((Object)MenuItems.VALIDATE)) {
            this.menuBuilder.addValidate(this.getValidateCommand());
        }
        if (this.menuItems.contains((Object)MenuItems.HISTORY)) {
            this.menuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu());
        }
        if (this.menuItems.contains((Object)MenuItems.DOWNLOAD)) {
            this.addDownloadMenuItem(this.menuBuilder);
        }
        return this.promises.resolve();
    }

    protected void addDownloadMenuItem(BasicFileMenuBuilder menuBuilder) {
        menuBuilder.addNewTopLevelMenu(this.downloadMenuItem());
    }

    protected MenuItem downloadMenuItem() {
        return this.downloadMenuItemBuilder.build(this.getPathSupplier());
    }

    Command getOnSave() {
        return this::onSave;
    }

    protected Command getSaveAndRename() {
        return this.getSaveAndRenameCommandBuilder().addPathSupplier(this.getPathSupplier()).addValidator(this.getRenameValidator()).addValidator(this.getSaveValidator()).addRenameService(this.getSaveAndRenameServiceCaller()).addMetadataSupplier(this.getMetadataSupplier()).addContentSupplier(this.getContentSupplier()).addIsDirtySupplier(this.isDirtySupplier()).addSuccessCallback(this.onSuccess()).build();
    }

    Supplier<Boolean> getSaveValidator() {
        return () -> {
            if (this.isReadOnly && this.versionRecordManager.isCurrentLatest()) {
                this.baseView.alertReadOnly();
                return false;
            }
            if (this.isReadOnly && !this.versionRecordManager.isCurrentLatest()) {
                this.versionRecordManager.restoreToCurrentVersion();
                return false;
            }
            if (this.concurrentUpdateSessionInfo != null) {
                this.showConcurrentUpdatePopup();
                return false;
            }
            return true;
        };
    }

    protected ParameterizedCommand<Path> onSuccess() {
        return path -> {
            T content = this.getContentSupplier().get();
            M metadata = this.getMetadataSupplier().get();
            this.setOriginalHash(content.hashCode());
            Optional<M> optionalMetadata = Optional.ofNullable(this.getMetadataSupplier().get());
            if (optionalMetadata.isPresent()) {
                this.setMetadataOriginalHash(metadata.hashCode());
            }
        };
    }

    protected SaveAndRenameCommandBuilder<T, M> getSaveAndRenameCommandBuilder() {
        return this.saveAndRenameCommandBuilder;
    }

    protected Supplier<Path> getPathSupplier() {
        return () -> this.versionRecordManager.getPathToLatest();
    }

    protected void buildMenuBar() {
        if (this.menuBuilder != null && this.menus == null) {
            this.menus = this.menuBuilder.build();
        }
    }

    public Validator getRenameValidator() {
        return this.fileNameValidator;
    }

    public Validator getCopyValidator() {
        return this.fileNameValidator;
    }

    private void selectVersion(VersionRecord versionRecord) {
        this.baseView.showBusyIndicator(CommonConstants.INSTANCE.Loading());
        this.isReadOnly = !this.versionRecordManager.isLatest(versionRecord);
        this.versionRecordManager.setVersion(versionRecord.id());
        this.loadContent();
    }

    public void setOriginalHash(Integer originalHash) {
        this.originalHash = originalHash;
    }

    private void addFileChangeListeners(final ObservablePath path) {
        path.onRename(new Command(){

            public void execute() {
                BaseEditor.this.onRename();
            }
        });
        path.onDelete(new Command(){

            public void execute() {
                BaseEditor.this.onDelete();
            }
        });
        path.onConcurrentUpdate((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentUpdateEvent>(){

            public void execute(ObservablePath.OnConcurrentUpdateEvent eventInfo) {
                BaseEditor.this.concurrentUpdateSessionInfo = eventInfo;
            }
        });
        path.onConcurrentRename((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentRenameEvent>(){

            public void execute(ObservablePath.OnConcurrentRenameEvent info) {
                ConcurrentChangePopup.newConcurrentRename((Path)info.getSource(), (Path)info.getTarget(), (User)info.getIdentity(), (Command)BaseEditor.this.onConcurrentRenameIgnoreCommand(path), (Command)BaseEditor.this.onConcurrentRenameCloseCommand(path)).show();
            }
        });
        path.onConcurrentDelete(this::onConcurrentDelete);
    }

    Command onConcurrentRenameIgnoreCommand(ObservablePath path) {
        return () -> {
            this.disableMenus();
            this.concurrentRenameIgnoredEvent.fire((Object)new ConcurrentRenameIgnoredEvent(path));
        };
    }

    Command onConcurrentRenameCloseCommand(ObservablePath path) {
        return () -> {
            this.reload();
            this.concurrentRenameAcceptedEvent.fire((Object)new ConcurrentRenameAcceptedEvent(path));
        };
    }

    void onConcurrentDelete(ObservablePath.OnConcurrentDelete info) {
        ConcurrentChangePopup.newConcurrentDelete((Path)info.getPath(), (User)info.getIdentity(), (Command)this.onConcurrentDeleteIgnoreCommand(this.path), (Command)this.onConcurrentDeleteCloseCommand(this.path)).show();
    }

    Command onConcurrentDeleteIgnoreCommand(ObservablePath path) {
        return () -> {
            this.disableMenus();
            this.disableDeletePopup();
            this.concurrentDeleteIgnoredEvent.fire((Object)new ConcurrentDeleteIgnoredEvent(path));
        };
    }

    Command onConcurrentDeleteCloseCommand(ObservablePath path) {
        return () -> {
            this.disableDeletePopup();
            this.placeManager.closePlace(this.place);
            this.concurrentDeleteAcceptedEvent.fire((Object)new ConcurrentDeleteAcceptedEvent(path));
        };
    }

    private void disableDeletePopup() {
        if (this.deletePopUpPresenter.isOpened()) {
            this.deletePopUpPresenter.cancel();
        }
    }

    private void onDelete() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                BaseEditor.this.placeManager.forceClosePlace(BaseEditor.this.place);
            }
        });
    }

    protected void onRename() {
        this.reload(this.path);
    }

    protected IsWidget getTitle() {
        this.refreshTitle(this.versionRecordManager.getCurrentPath());
        return this.getTitleWidget();
    }

    EditorTitle getTitleWidget() {
        return this.baseView.getTitleWidget();
    }

    public String getTitleText() {
        return this.getTitleText(this.versionRecordManager.getCurrentPath());
    }

    String getTitleText(ObservablePath observablePath) {
        return observablePath.getFileName() + " - " + this.getType().getDescription();
    }

    ClientResourceType getType() {
        return this.type;
    }

    protected void onSave() {
        boolean isValid = this.getSaveValidator().get();
        if (isValid) {
            this.save();
        }
    }

    protected void showConcurrentUpdatePopup() {
        ConcurrentChangePopup.newConcurrentUpdate((Path)this.concurrentUpdateSessionInfo.getPath(), (User)this.concurrentUpdateSessionInfo.getIdentity(), (Command)new Command(){

            public void execute() {
                BaseEditor.this.save();
            }
        }, (Command)new Command(){

            public void execute() {
            }
        }, (Command)new Command(){

            public void execute() {
                BaseEditor.this.reload();
            }
        }).show();
    }

    public RemoteCallback<Path> getSaveSuccessCallback(final int newHash) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                BaseEditor.this.baseView.hideBusyIndicator();
                BaseEditor.this.versionRecordManager.reloadVersions(path);
                BaseEditor.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemSavedSuccessfully()));
                BaseEditor.this.setOriginalHash(newHash);
            }
        };
    }

    public void onRestore(@Observes RestoreEvent restore) {
        if (this.versionRecordManager.getCurrentPath() == null || restore == null || restore.getPath() == null) {
            return;
        }
        if (this.versionRecordManager.getCurrentPath().equals(restore.getPath())) {
            this.init(this.versionRecordManager.getPathToLatest(), this.place, this.type, false, this.displayShowMoreVersions, new MenuItems[0]);
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRestored()));
        }
    }

    public void reload() {
        this.concurrentUpdateSessionInfo = null;
        this.reload(this.versionRecordManager.getCurrentPath());
    }

    void reload(ObservablePath path) {
        this.refreshTitle(path);
        this.showBusyIndicator();
        this.loadContent();
        this.notifyChangeTitle(path);
        this.initVersionRecordManager();
    }

    void refreshTitle(ObservablePath observablePath) {
        this.baseView.refreshTitle(this.getTitleText(observablePath));
    }

    void showBusyIndicator() {
        this.baseView.showBusyIndicator(this.makeLoading());
    }

    String makeLoading() {
        return CommonConstants.INSTANCE.Loading();
    }

    void notifyChangeTitle(ObservablePath path) {
        this.changeTitleNotification.fire((Object)this.makeChangeTitleWidgetEvent(path));
    }

    ChangeTitleWidgetEvent makeChangeTitleWidgetEvent(ObservablePath path) {
        String titleText = this.getTitleText(path);
        EditorTitle titleWidget = this.getTitleWidget();
        return new ChangeTitleWidgetEvent(this.getPlace(), titleText, (IsWidget)titleWidget);
    }

    void initVersionRecordManager() {
        String version = this.getPlace().getParameter("version", null);
        Callback<VersionRecord> selectVersion = this.getSelectVersion();
        this.versionRecordManager.init(version, this.versionRecordManager.getCurrentPath(), selectVersion);
    }

    Callback<VersionRecord> getSelectVersion() {
        return this::selectVersion;
    }

    PlaceRequest getPlace() {
        return this.place;
    }

    void disableMenus() {
        this.disableMenuItem(MenuItems.COPY);
        this.disableMenuItem(MenuItems.RENAME);
        this.disableMenuItem(MenuItems.DELETE);
        this.disableMenuItem(MenuItems.VALIDATE);
    }

    public void disableMenuItem(MenuItems menuItem) {
        this.setEnableMenuItem(menuItem, false);
    }

    public void enableMenuItem(MenuItems menuItem) {
        this.setEnableMenuItem(menuItem, true);
    }

    private void setEnableMenuItem(MenuItems menuItem, boolean isEnabled) {
        this.getMenus(menus -> {
            if (menus.getItemsMap().containsKey((Object)menuItem)) {
                ((MenuItem)menus.getItemsMap().get((Object)menuItem)).setEnabled(isEnabled);
            }
        });
    }

    public void getMenus(Consumer<Menus> menusConsumer) {
        if (this.menus != null) {
            menusConsumer.accept(this.menus);
            return;
        }
        if (this.makeMenuBarPromise == null) {
            this.makeMenuBarPromise = this.makeMenuBar().then(v -> {
                this.buildMenuBar();
                menusConsumer.accept(this.menus);
                return this.promises.resolve();
            });
        } else {
            this.makeMenuBarPromise.then(v -> {
                menusConsumer.accept(this.menus);
                return this.promises.resolve();
            });
        }
    }

    public Command getValidateCommand() {
        return new Command(){

            public void execute() {
                if (!BaseEditor.this.isValidationRunning) {
                    BaseEditor.this.onBeforeValidate();
                    BaseEditor.this.onValidate(new Command(){

                        public void execute() {
                            BaseEditor.this.onAfterValidate();
                        }
                    });
                }
            }
        };
    }

    protected void onBeforeValidate() {
        this.baseView.showBusyIndicator(CommonConstants.INSTANCE.Validating());
        this.isValidationRunning = true;
    }

    protected void onAfterValidate() {
        this.baseView.hideBusyIndicator();
        this.isValidationRunning = false;
    }

    protected void onValidate(Command finished) {
    }

    protected abstract void loadContent();

    protected Supplier<T> getContentSupplier() {
        return () -> null;
    }

    protected Supplier<Boolean> isDirtySupplier() {
        return () -> this.isContentDirty() || this.isMetadataDirty();
    }

    boolean isMetadataDirty() {
        Optional<M> optionalMetadata = Optional.ofNullable(this.getMetadataSupplier().get());
        if (optionalMetadata.isPresent()) {
            return this.isMetadataDirty(optionalMetadata.get());
        }
        return false;
    }

    private boolean isMetadataDirty(M metadata) {
        Integer metadataCurrentHash = metadata.hashCode();
        return !metadataCurrentHash.equals(this.metadataOriginalHash);
    }

    boolean isContentDirty() {
        return this.isDirty(this.getCurrentContentHash());
    }

    protected Integer getCurrentContentHash() {
        try {
            return this.getContentSupplier().get().hashCode();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Supplier<M> getMetadataSupplier() {
        return () -> null;
    }

    protected void save() {
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return null;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return null;
    }

    protected Caller<? extends SupportsSaveAndRename<T, M>> getSaveAndRenameServiceCaller() {
        return null;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return null;
    }

    public boolean mayClose(Integer currentHash) {
        if (this.isDirty(currentHash)) {
            return this.baseView.confirmClose();
        }
        return true;
    }

    public boolean isDirty(Integer currentHash) {
        if (this.originalHash == null) {
            return currentHash != null;
        }
        return !this.originalHash.equals(currentHash);
    }

    public VersionRecordManager getVersionRecordManager() {
        return this.versionRecordManager;
    }

    public void setMetadataOriginalHash(Integer metadataOriginalHash) {
        this.metadataOriginalHash = metadataOriginalHash;
    }
}

