/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.activities;

import java.util.UUID;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.activities.ReusableSubprocessConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.CallActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BaseReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.IsCase;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocAutostart;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.CalledElement;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Independent;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsMultipleInstance;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCompletionCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceExecutionMode;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.WaitForCompletion;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ReusableSubprocessConverterTest {
    private static final String UUID = "UUID";
    private static final String NAME = "NAME";
    private static final String DOCUMENTATION = "DOCUMENTATION";
    private static final String CALLED_ELEMENT = "CALLED_ELEMENT";
    private static final Boolean INDEPENDENT = Boolean.TRUE;
    private static final Boolean IS_CASE = Boolean.FALSE;
    private static final Boolean WAIT_FOR_COMPLETION = Boolean.TRUE;
    private static final Boolean IS_ASYNC = Boolean.TRUE;
    private static final Boolean IS_ADHOC_AUTOSTART = Boolean.FALSE;
    private static final Boolean IS_MULTIPLE_INSTANCE = Boolean.TRUE;
    private static final Boolean SEQUENTIAL = Boolean.TRUE;
    private static final String COLLECTION_INPUT = "COLLECTION_INPUT";
    private static final String COLLECTION_OUTPUT = "COLLECTION_OUTPUT";
    private static final String DATA_INPUT = "DATA_INPUT";
    private static final String DATA_OUTPUT = "DATA_OUTPUT";
    private static final String COMPLETION_CONDITION = "COMPLETION_CONDITION";
    private static final OnEntryAction ON_ENTRY_ACTION = new OnEntryAction();
    private static final OnExitAction ON_EXIT_ACTION = new OnExitAction();
    private static final Bounds BOUNDS = Bounds.create();
    private static final SimulationSet SIMULATION_SET = new SimulationSet();
    private static final AssignmentsInfo ASSIGNMENTS_INFO = new AssignmentsInfo();
    @Mock
    private PropertyWriterFactory propertyWriterFactory;
    @Mock
    private CallActivityPropertyWriter propertyWriter;
    @Captor
    private ArgumentCaptor<CallActivity> activityCaptor;
    private Node<View<BaseReusableSubprocess>, ?> node;
    private ReusableSubprocessConverter converter;
    private ReusableSubprocessConverter tested = new ReusableSubprocessConverter(new PropertyWriterFactory());

    @Before
    public void setUp() {
        Mockito.when((Object)this.propertyWriterFactory.of((CallActivity)Matchers.any(CallActivity.class))).thenReturn((Object)this.propertyWriter);
        DataIOSet ioSet = (DataIOSet)Mockito.mock(DataIOSet.class);
        Mockito.when((Object)ioSet.getAssignmentsinfo()).thenReturn((Object)ASSIGNMENTS_INFO);
        ReusableSubprocess definition = new ReusableSubprocess(new BPMNGeneralSet(NAME, DOCUMENTATION), new ReusableSubprocessTaskExecutionSet(new CalledElement(CALLED_ELEMENT), new IsCase(IS_CASE), new Independent(INDEPENDENT), new WaitForCompletion(WAIT_FOR_COMPLETION), new IsAsync(IS_ASYNC), new AdHocAutostart(IS_ADHOC_AUTOSTART), new IsMultipleInstance(IS_MULTIPLE_INSTANCE), new MultipleInstanceExecutionMode(SEQUENTIAL.booleanValue()), new MultipleInstanceCollectionInput(COLLECTION_INPUT), new MultipleInstanceDataInput(DATA_INPUT), new MultipleInstanceCollectionOutput(COLLECTION_OUTPUT), new MultipleInstanceDataOutput(DATA_OUTPUT), new MultipleInstanceCompletionCondition(COMPLETION_CONDITION), ON_ENTRY_ACTION, ON_EXIT_ACTION), ioSet, new BackgroundSet(), new FontSet(), new RectangleDimensionsSet(), SIMULATION_SET);
        ViewImpl view = new ViewImpl((Object)definition, BOUNDS);
        this.node = new NodeImpl(UUID);
        this.node.setContent((Object)view);
        this.converter = new ReusableSubprocessConverter(this.propertyWriterFactory);
    }

    @Test
    public void testToFlowElementMI() {
        Assert.assertEquals((Object)this.propertyWriter, (Object)this.converter.toFlowElement(this.node));
        this.verifyCommonValues();
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setIsSequential(SEQUENTIAL.booleanValue());
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setCollectionInput(COLLECTION_INPUT);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setInput(DATA_INPUT);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setCollectionOutput(COLLECTION_OUTPUT);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setOutput(DATA_OUTPUT);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setCompletionCondition(COMPLETION_CONDITION);
    }

    @Test
    public void testToFlowElementNonMI() {
        ((BaseReusableSubprocess)((View)this.node.getContent()).getDefinition()).getExecutionSet().getIsMultipleInstance().setValue(Boolean.valueOf(false));
        Assert.assertEquals((Object)this.propertyWriter, (Object)this.converter.toFlowElement(this.node));
        this.verifyCommonValues();
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter, (VerificationMode)Mockito.never())).setIsSequential(Matchers.anyBoolean());
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter, (VerificationMode)Mockito.never())).setCollectionInput(Matchers.anyString());
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter, (VerificationMode)Mockito.never())).setInput(Matchers.anyString());
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter, (VerificationMode)Mockito.never())).setCollectionOutput(Matchers.anyString());
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter, (VerificationMode)Mockito.never())).setOutput(Matchers.anyString());
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter, (VerificationMode)Mockito.never())).setCompletionCondition(Matchers.anyString());
    }

    private void verifyCommonValues() {
        ((PropertyWriterFactory)Mockito.verify((Object)this.propertyWriterFactory)).of((CallActivity)this.activityCaptor.capture());
        Assert.assertEquals((Object)UUID, (Object)((CallActivity)this.activityCaptor.getValue()).getId());
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setName(NAME);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setDocumentation(DOCUMENTATION);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setOnEntryAction(ON_ENTRY_ACTION);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setOnExitAction(ON_EXIT_ACTION);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setCalledElement(CALLED_ELEMENT);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setAsync(IS_ASYNC);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setIndependent(INDEPENDENT);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setWaitForCompletion(WAIT_FOR_COMPLETION);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setAssignmentsInfo(ASSIGNMENTS_INFO);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setSimulationSet(SIMULATION_SET);
        ((CallActivityPropertyWriter)Mockito.verify((Object)this.propertyWriter)).setAbsoluteBounds(this.node);
    }

    @Test
    public void testToFlowElement_case() {
        ReusableSubprocess definition = new ReusableSubprocess();
        definition.getExecutionSet().setIsCase(new IsCase(Boolean.valueOf(true)));
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(java.util.UUID.randomUUID().toString());
        node.setContent((Object)view);
        PropertyWriter propertyWriter = this.tested.toFlowElement((Node)node);
        Assert.assertTrue((boolean)CallActivityPropertyWriter.class.isInstance(propertyWriter));
        Assert.assertTrue((boolean)((Boolean)CustomElement.isCase.of((BaseElement)propertyWriter.getFlowElement()).get()));
    }

    @Test
    public void testToFlowElement_process() {
        ReusableSubprocess definition = new ReusableSubprocess();
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(java.util.UUID.randomUUID().toString());
        node.setContent((Object)view);
        PropertyWriter propertyWriter = this.tested.toFlowElement((Node)node);
        Assert.assertTrue((boolean)CallActivityPropertyWriter.class.isInstance(propertyWriter));
        Assert.assertFalse((boolean)((Boolean)CustomElement.isCase.of((BaseElement)propertyWriter.getFlowElement()).get()));
    }

    @Test
    public void testToFlowElement_autostart() {
        ReusableSubprocess definition = new ReusableSubprocess();
        definition.getExecutionSet().setAdHocAutostart(new AdHocAutostart(Boolean.valueOf(true)));
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(java.util.UUID.randomUUID().toString());
        node.setContent((Object)view);
        PropertyWriter propertyWriter = this.tested.toFlowElement((Node)node);
        Assert.assertTrue((boolean)CallActivityPropertyWriter.class.isInstance(propertyWriter));
        Assert.assertTrue((boolean)((Boolean)CustomElement.autoStart.of((BaseElement)propertyWriter.getFlowElement()).get()));
    }

    @Test
    public void testToFlowElement_notautostart() {
        ReusableSubprocess definition = new ReusableSubprocess();
        definition.getExecutionSet().setAdHocAutostart(new AdHocAutostart(Boolean.valueOf(false)));
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(java.util.UUID.randomUUID().toString());
        node.setContent((Object)view);
        PropertyWriter propertyWriter = this.tested.toFlowElement((Node)node);
        Assert.assertTrue((boolean)CallActivityPropertyWriter.class.isInstance(propertyWriter));
        Assert.assertFalse((boolean)((Boolean)CustomElement.autoStart.of((BaseElement)propertyWriter.getFlowElement()).get()));
    }
}

