/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations;

import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNShape;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.AssociationPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.util.PropertyWriterUtilsTest;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AssociationPropertyWriterTest {
    private static final String SOURCE_SHAPE_ID = "SOURCE_SHAPE_ID";
    private static final String TARGET_SHAPE_ID = "TARGET_SHAPE_ID";
    @Mock
    private Association association;
    @Mock
    private VariableScope variableScope;
    @Mock
    private BasePropertyWriter sourceWriter;
    @Mock
    private BaseElement sourceElement;
    @Mock
    private BasePropertyWriter targetWriter;
    @Mock
    private BaseElement targetElement;
    private AssociationPropertyWriter associationWriter;

    @Before
    public void setUp() {
        Mockito.when((Object)this.sourceWriter.getElement()).thenReturn((Object)this.sourceElement);
        Mockito.when((Object)this.targetWriter.getElement()).thenReturn((Object)this.targetElement);
        this.associationWriter = new AssociationPropertyWriter(this.association, this.variableScope);
    }

    @Test
    public void testSetConnection() {
        BPMNShape sourceShape = PropertyWriterUtilsTest.mockShape(SOURCE_SHAPE_ID, 1.0f, 1.0f, 4.0f, 4.0f);
        BPMNShape targetShape = PropertyWriterUtilsTest.mockShape(TARGET_SHAPE_ID, 10.0f, 10.0f, 4.0f, 4.0f);
        Mockito.when((Object)this.sourceWriter.getShape()).thenReturn((Object)sourceShape);
        Mockito.when((Object)this.targetWriter.getShape()).thenReturn((Object)targetShape);
        ControlPoint[] controlPoints = new ControlPoint[]{new ControlPoint(Point2D.create((double)3.0, (double)3.0)), new ControlPoint(Point2D.create((double)4.0, (double)4.0)), new ControlPoint(Point2D.create((double)5.0, (double)5.0))};
        ViewConnector<? extends BPMNViewDefinition> connector = PropertyWriterUtilsTest.mockConnector(1.0, 1.0, 10.0, 10.0, controlPoints);
        this.associationWriter.setSource(this.sourceWriter);
        this.associationWriter.setTarget(this.targetWriter);
        this.associationWriter.setConnection(connector);
        Assert.assertNotNull((Object)this.associationWriter.getEdge());
        Assert.assertEquals((Object)this.association, (Object)this.associationWriter.getEdge().getBpmnElement());
        Assert.assertEquals((Object)"edge_SOURCE_SHAPE_ID_to_TARGET_SHAPE_ID", (Object)this.associationWriter.getEdge().getId());
        PropertyWriterUtilsTest.assertWaypoint(2.0f, 2.0f, 0, this.associationWriter.getEdge().getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(3.0f, 3.0f, 1, this.associationWriter.getEdge().getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(4.0f, 4.0f, 2, this.associationWriter.getEdge().getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(5.0f, 5.0f, 3, this.associationWriter.getEdge().getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(20.0f, 20.0f, 4, this.associationWriter.getEdge().getWaypoint());
    }

    @Test
    public void testSetSource() {
        this.associationWriter.setSource(this.sourceWriter);
        ((Association)Mockito.verify((Object)this.association)).setSourceRef(this.sourceElement);
        ((BasePropertyWriter)Mockito.verify((Object)this.sourceWriter)).setTarget((BasePropertyWriter)this.associationWriter);
    }

    @Test
    public void testSetTarget() {
        this.associationWriter.setTarget(this.targetWriter);
        ((Association)Mockito.verify((Object)this.association)).setTargetRef(this.targetElement);
        ((BasePropertyWriter)Mockito.verify((Object)this.targetWriter)).setSource((BasePropertyWriter)this.associationWriter);
    }

    public void testSetOneDirectionAssociation() {
        ((Association)Mockito.verify((Object)this.association)).setAssociationDirection(AssociationDirection.ONE);
    }
}

