/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BoundaryEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.UserTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseFileVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseIdPrefix;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.GlobalVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessPropertyWriterTest {
    ProcessPropertyWriter p;
    FlatVariableScope variableScope;

    @Before
    public void before() {
        this.variableScope = new FlatVariableScope();
        this.p = new ProcessPropertyWriter(Factories.bpmn2.createProcess(), (VariableScope)this.variableScope);
    }

    @Test
    public void setIdWithWhitespace() {
        this.p.setId("some weird   id \t");
        Process process = this.p.getProcess();
        Assertions.assertThat((String)process.getId()).isEqualTo((Object)"someweirdid");
    }

    @Test
    public void addChildElement() {
        Process process = this.p.getProcess();
        BoundaryEventPropertyWriter boundaryEventPropertyWriter = new BoundaryEventPropertyWriter(Factories.bpmn2.createBoundaryEvent(), (VariableScope)this.variableScope);
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope);
        this.p.addChildElement((BasePropertyWriter)boundaryEventPropertyWriter);
        this.p.addChildElement((BasePropertyWriter)userTaskPropertyWriter);
        Assertions.assertThat(process.getFlowElements().get(0)).isEqualTo((Object)userTaskPropertyWriter.getFlowElement());
        Assertions.assertThat(process.getFlowElements().get(1)).isEqualTo((Object)boundaryEventPropertyWriter.getFlowElement());
    }

    @Test
    public void addChildShape() {
        BPMNShape bpmnShape = Factories.di.createBPMNShape();
        bpmnShape.setId("a");
        this.p.addChildShape(bpmnShape);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.p.addChildShape(bpmnShape)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot add the same shape twice");
    }

    @Test
    public void addChildEdge() {
        BPMNEdge bpmnEdge = Factories.di.createBPMNEdge();
        bpmnEdge.setId("a");
        this.p.addChildEdge(bpmnEdge);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.p.addChildEdge(bpmnEdge)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot add the same edge twice");
    }

    @Test
    public void caseRoles() {
        CaseRoles caseRole = new CaseRoles("role");
        this.p.setCaseRoles(caseRole);
        String cdata = (String)CustomElement.caseRole.of((BaseElement)this.p.getProcess()).get();
        Assertions.assertThat((String)"role").isEqualTo((Object)CustomElement.caseRole.stripCData(cdata));
    }

    @Test
    public void caseIdPrefix() {
        CaseIdPrefix caseIdPrefix = new CaseIdPrefix("caseIdPrefix");
        this.p.setCaseIdPrefix(caseIdPrefix);
        String cdata = (String)CustomElement.caseIdPrefix.of((BaseElement)this.p.getProcess()).get();
        Assertions.assertThat((String)"caseIdPrefix").isEqualTo((Object)CustomElement.caseIdPrefix.stripCData(cdata));
    }

    @Test
    public void caseFileVariables() {
        CaseFileVariables caseFileVariables = new CaseFileVariables("CFV1:Boolean,CFV2:Boolean,CFV3:Boolean");
        this.p.setCaseFileVariables(caseFileVariables);
        Assertions.assertThat((this.p.itemDefinitions.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void executable() {
        this.p.setExecutable(Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.p.getProcess().isIsExecutable());
        this.p.setExecutable(Boolean.valueOf(false));
        Assert.assertFalse((boolean)this.p.getProcess().isIsExecutable());
    }

    @Test
    public void globalVariables() {
        GlobalVariables globalVariables = new GlobalVariables("GV1:Boolean,GV2:Boolean,GV3:Integer");
        this.p.setGlobalVariables(globalVariables);
        String globalVariablesString = (String)CustomElement.globalVariables.of((BaseElement)this.p.getProcess()).get();
        Assertions.assertThat((String)globalVariablesString).isEqualTo((Object)"GV1:Boolean,GV2:Boolean,GV3:Integer");
    }

    @Test
    public void slaDueDate() {
        SLADueDate slaDueDate = new SLADueDate("12/25/1983");
        this.p.setSlaDueDate(slaDueDate);
        String slaDueDateString = (String)CustomElement.slaDueDate.of((BaseElement)this.p.getProcess()).get();
        Assertions.assertThat((String)slaDueDateString).isEqualTo((Object)"<![CDATA[12/25/1983]]>");
    }

    @Test
    public void testSetDocumentationNotEmpty() {
        this.p.setDocumentation("DocumentationValue");
        Assert.assertNotNull((Object)this.p.getProcess().getDocumentation());
        Assert.assertEquals((long)1L, (long)this.p.getProcess().getDocumentation().size());
        Assert.assertEquals((Object)"<![CDATA[DocumentationValue]]>", (Object)((Documentation)this.p.getProcess().getDocumentation().get(0)).getText());
    }
}

