/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AssociationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.util.PropertyReaderUtils;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PropertyReaderUtils.class})
public class AssociationPropertyReaderTest {
    private static String SOURCE_ID = "SOURCE_ID";
    private static String TARGET_ID = "TARGET_ID";
    private static String ASSOCIATION_ID = "ASSOCIATION_ID";
    private static double X = 1.0;
    private static double Y = 2.0;
    @Mock
    private DefinitionResolver definitionResolver;
    @Mock
    private Association association;
    @Mock
    private BaseElement sourceRef;
    @Mock
    private BaseElement targetRef;
    @Mock
    private BPMNDiagram bpmnDiagram;
    @Mock
    private BPMNPlane bpmnLane;
    private Point2D position;
    @Mock
    private AssociationPropertyReader propertyReader;

    @Before
    public void setUp() {
        this.position = Point2D.create((double)X, (double)Y);
        Mockito.when((Object)this.bpmnDiagram.getPlane()).thenReturn((Object)this.bpmnLane);
        Mockito.when((Object)this.association.getId()).thenReturn((Object)ASSOCIATION_ID);
        Mockito.when((Object)this.sourceRef.getId()).thenReturn((Object)SOURCE_ID);
        Mockito.when((Object)this.targetRef.getId()).thenReturn((Object)TARGET_ID);
        Mockito.when((Object)this.association.getSourceRef()).thenReturn((Object)this.sourceRef);
        Mockito.when((Object)this.association.getTargetRef()).thenReturn((Object)this.targetRef);
        this.propertyReader = new AssociationPropertyReader(this.association, this.bpmnDiagram, this.definitionResolver);
    }

    @Test
    public void testGetSourceId() {
        Assert.assertEquals((Object)SOURCE_ID, (Object)this.propertyReader.getSourceId());
    }

    @Test
    public void testGetTargetId() {
        Assert.assertEquals((Object)TARGET_ID, (Object)this.propertyReader.getTargetId());
    }

    @Test
    public void testGetSourceConnection() {
        PowerMockito.mockStatic(PropertyReaderUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)PropertyReaderUtils.getSourcePosition((DefinitionResolver)this.definitionResolver, (String)ASSOCIATION_ID, (String)SOURCE_ID)).thenReturn((Object)this.position);
        boolean arbitraryBoolean = true;
        PowerMockito.when((Object)PropertyReaderUtils.isAutoConnectionSource((BaseElement)this.association)).thenReturn((Object)arbitraryBoolean);
        Connection result = this.propertyReader.getSourceConnection();
        Assert.assertEquals((double)X, (double)result.getLocation().getX(), (double)0.0);
        Assert.assertEquals((double)Y, (double)result.getLocation().getY(), (double)0.0);
    }

    @Test
    public void testGetTargetConnection() {
        PowerMockito.mockStatic(PropertyReaderUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)PropertyReaderUtils.getTargetPosition((DefinitionResolver)this.definitionResolver, (String)ASSOCIATION_ID, (String)TARGET_ID)).thenReturn((Object)this.position);
        boolean arbitraryBoolean = true;
        PowerMockito.when((Object)PropertyReaderUtils.isAutoConnectionSource((BaseElement)this.association)).thenReturn((Object)arbitraryBoolean);
        Connection result = this.propertyReader.getTargetConnection();
        Assert.assertEquals((double)X, (double)result.getLocation().getX(), (double)0.0);
        Assert.assertEquals((double)Y, (double)result.getLocation().getY(), (double)0.0);
    }

    @Test
    public void testGetControlPoints() {
        List controlPoints = (List)PowerMockito.mock(List.class);
        PowerMockito.mockStatic(PropertyReaderUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)PropertyReaderUtils.getControlPoints((DefinitionResolver)this.definitionResolver, (String)ASSOCIATION_ID)).thenReturn((Object)controlPoints);
        Assert.assertEquals((Object)controlPoints, (Object)this.propertyReader.getControlPoints());
    }
}

