/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Collections;
import java.util.UUID;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CallActivityPropertyReader;

public class CallActivityPropertyReaderTest {
    private DefinitionResolver definitionResolver;
    private CallActivityPropertyReader tested;

    @Before
    public void setUp() throws Exception {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
    }

    @Test
    public void testIsCase_true() throws Exception {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertTrue((boolean)this.tested.isCase());
    }

    @Test
    public void testIsCase_false() throws Exception {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.FALSE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertFalse((boolean)this.tested.isCase());
    }

    @Test
    public void testIsAdHocAutostart_true() throws Exception {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.autoStart.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertTrue((boolean)this.tested.isAdHocAutostart());
    }

    @Test
    public void testIsAdHocAutostart_false() throws Exception {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.autoStart.of((BaseElement)callActivity).set((Object)Boolean.FALSE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertFalse((boolean)this.tested.isAdHocAutostart());
    }
}

