/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedNotificationsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;

public class ParsedNotificationsInfosTest {
    @Test
    public void testNotification() {
        String body = "[from:director|tousers:director,jack,katy|togroups:Forms,IT|replyTo:guest|subject:asd|body:asd]@[11h]";
        NotificationValue actual = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)body);
        NotificationValue expected = new NotificationValue();
        expected.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        expected.setFrom("director");
        expected.setReplyTo("guest");
        expected.setSubject("asd");
        expected.setBody("asd");
        expected.setExpiresAt("11h");
        expected.setGroups(new ArrayList<String>(Arrays.asList("Forms", "IT")));
        expected.setUsers(new ArrayList<String>(Arrays.asList("director", "jack", "katy")));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNotificationPartial() {
        String body = "[from:|tousers:|togroups:|replyTo:|subject:|body:]@[0h]]";
        NotificationValue actual = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)body);
        NotificationValue expected = new NotificationValue();
        expected.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        expected.setExpiresAt("0h");
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertEquals((Object)expected.toCDATAFormat(), (Object)actual.toCDATAFormat());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNotificationEmpty() {
        NotificationValue value = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)"");
        NotificationValue valid = new NotificationValue();
        valid.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        Assert.assertEquals((Object)valid, (Object)value);
    }
}

