/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.dataprovider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindRuleFlowNamesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.stunner.bpmn.backend.dataproviders.RuleFlowGroupFormProvider;
import org.mockito.Mockito;

public class RuleFlowGroupFormProviderTest {
    private static final String ERROR_MSG = PartType.ACTIVATION_GROUP.toString() + "' can not be used";

    @Test
    public void findRuleFlowNamesQueryTermsTest() {
        FindRuleFlowNamesQuery query = new FindRuleFlowNamesQuery();
        HashSet<ValueSharedPartIndexTerm> queryTerms = new HashSet<ValueSharedPartIndexTerm>();
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required rule-flow term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains("At least 1 term"));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("not-rule-flow", PartType.ACTIVATION_GROUP));
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required rule-flow term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains(ERROR_MSG));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("not-rule-flow", PartType.ACTIVATION_GROUP));
        queryTerms.add(new ValueSharedPartIndexTerm("rule-flow", PartType.RULEFLOW_GROUP));
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The activation term is not acceptable here, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains(ERROR_MSG));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueSharedPartIndexTerm("rule-flow", PartType.RULEFLOW_GROUP));
        query.validateTerms(queryTerms);
    }

    @Test
    public void testDefaultResultConverter() {
        RefactoringPageRow row1 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        Mockito.when((Object)row1.getValue()).thenReturn(RuleFlowGroupFormProviderTest.asMap("row1"));
        RefactoringPageRow row2 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        Mockito.when((Object)row2.getValue()).thenReturn(RuleFlowGroupFormProviderTest.asMap("row2"));
        RefactoringPageRow row3 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        Mockito.when((Object)row3.getValue()).thenReturn(RuleFlowGroupFormProviderTest.asMap("row3"));
        RefactoringPageRow row4 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        Mockito.when((Object)row4.getValue()).thenReturn(RuleFlowGroupFormProviderTest.asMap("row4"));
        RefactoringPageRow row4_2 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        Mockito.when((Object)row4_2.getValue()).thenReturn(RuleFlowGroupFormProviderTest.asMap("row4"));
        RefactoringPageRow emptyRow1 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        Mockito.when((Object)emptyRow1.getValue()).thenReturn(RuleFlowGroupFormProviderTest.asMap(""));
        RefactoringPageRow emptyRow2 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        Mockito.when((Object)emptyRow2.getValue()).thenReturn(RuleFlowGroupFormProviderTest.asMap(""));
        List<RefactoringPageRow> rows = Arrays.asList(row1, row2, row3, row4, row4_2, emptyRow1, emptyRow2);
        TreeMap result = (TreeMap)RuleFlowGroupFormProvider.DEFAULT_RESULT_CONVERTER.apply(rows);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("row1"));
        Assert.assertTrue((boolean)result.containsKey("row2"));
        Assert.assertTrue((boolean)result.containsKey("row3"));
        Assert.assertTrue((boolean)result.containsKey("row4"));
    }

    private static Map<String, String> asMap(String s) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("name", s);
        return map;
    }
}

