/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.InterruptingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartConditionalEventTest
extends StartEventTest<StartConditionalEvent> {
    private static final String BPMN_CONDITIONAL_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startConditionalEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_6148BD21-0D19-4B66-9FB7-7F19A078465B";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_14C6EB8F-09FF-454E-A0C5-50D4A38392A0";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_C5369C96-8531-4D05-88DA-9261189D70B2";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_AC859BAB-5995-4125-9C6E-A4A3B9476020";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 10;
    private static final String CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE = null;
    private static final String CONDITION_EXPRESSION_LANGUAGE = "drools";
    private static final String CONDITION_ERPRESSION_TYPE = "stunner.bpmn.ScriptType";

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Conditional event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Conditional event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CONDITIONAL_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 10);
        StartConditionalEvent filledTop = this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, StartConditionalEvent.class);
        this.assertGeneralSet(filledTop.getGeneral(), "Conditional event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Conditional event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledTop.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CONDITIONAL_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 10);
        StartConditionalEvent emptyTop = this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, StartConditionalEvent.class);
        this.assertGeneralSet(emptyTop.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptyTop.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, true, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Conditional event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Conditional event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CONDITIONAL_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 10);
        StartConditionalEvent filledSubprocess = this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, StartConditionalEvent.class);
        this.assertGeneralSet(filledSubprocess.getGeneral(), "Conditional event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Conditional event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledSubprocess.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CONDITIONAL_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 10);
        StartConditionalEvent emptySubprocess = this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, StartConditionalEvent.class);
        this.assertGeneralSet(emptySubprocess.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptySubprocess.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, false, "");
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_CONDITIONAL_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    Class<StartConditionalEvent> getStartEventType() {
        return StartConditionalEvent.class;
    }

    private void assertConditionalEventExecutionSet(InterruptingConditionalEventExecutionSet executionSet, String conditionExpressionScript, String conditionExpressionLanguage, String conditionExpressionType, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getConditionExpression());
        Assert.assertNotNull((Object)executionSet.getConditionExpression().getValue());
        Assert.assertNotNull((Object)executionSet.getConditionExpression().getType());
        Assert.assertEquals((Object)conditionExpressionLanguage, (Object)executionSet.getConditionExpression().getValue().getLanguage());
        Assert.assertEquals((Object)conditionExpressionScript, (Object)executionSet.getConditionExpression().getValue().getScript());
        Assert.assertEquals((Object)conditionExpressionType, (Object)executionSet.getConditionExpression().getType().getName());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }
}

