/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartNoneEventTest
extends StartEventTest<StartNoneEvent> {
    private static final String BPMN_START_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startNoneEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "D248D0BE-78CA-4980-99C8-93F9B8A0BC4C";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "1BA1C8C8-16DA-49A5-9C04-2F165B5A4273";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "6B710126-9C80-4409-9A49-4EECD2F88A14";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "6A19FF0A-296B-4BC5-B951-C380B8E7AB56";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 11;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Hello none start event name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\nDocumentation";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartNoneEvent filledTop = this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, StartNoneEvent.class);
        this.assertGeneralSet(filledTop.getGeneral(), "Hello none start event name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\nDocumentation");
        Assert.assertNotNull((Object)filledTop.getExecutionSet());
        this.assertStartEventSlaDueDate(filledTop.getExecutionSet(), SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartNoneEvent emptyTop = this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, StartNoneEvent.class);
        this.assertGeneralSet(emptyTop.getGeneral(), "", "");
        Assert.assertNotNull((Object)emptyTop.getExecutionSet());
        this.assertStartEventSlaDueDate(emptyTop.getExecutionSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "It is also not empty ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "Some documentation as well\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartNoneEvent filledSubprocess = this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, StartNoneEvent.class);
        this.assertGeneralSet(filledSubprocess.getGeneral(), "It is also not empty ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "Some documentation as well\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n");
        Assert.assertNotNull((Object)filledSubprocess.getExecutionSet());
        this.assertStartEventSlaDueDate(filledSubprocess.getExecutionSet(), SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartNoneEvent emptySubprocess = this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, StartNoneEvent.class);
        this.assertGeneralSet(emptySubprocess.getGeneral(), "", "");
        Assert.assertNotNull((Object)emptySubprocess.getExecutionSet());
        this.assertStartEventSlaDueDate(emptySubprocess.getExecutionSet(), "");
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_START_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    Class<StartNoneEvent> getStartEventType() {
        return StartNoneEvent.class;
    }
}

