/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.BoundaryCatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.CancellingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class BoundaryCatchingIntermediateConditionalEventTest
extends BoundaryCatchingIntermediateEventTest<IntermediateConditionalEvent> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundaryConditionalEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_8284FFB2-83A5-4AED-923C-31B5D3BB5E40";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_467655EB-2470-463C-B957-944F4592856D";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_7BEE831A-6679-4BF8-B420-EAC9A904828A";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_3FCB8D12-4889-4A60-9125-1CB8685381C4";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_8F3A4A49-486A-414B-B3C0-2AB6A70653F3";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_877C1825-122D-408B-A8F2-00B1AD798544";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_F114AEE8-DA28-4A26-8B77-1E69AA39BB63";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_A1BB3E61-B2BD-4EA2-AF80-73EAC4DF5F3E";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 31;
    private static final String CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE = null;
    private static final String CONDITION_EXPRESSION_LANGUAGE = "drools";
    private static final String CONDITION_ERPRESSION_TYPE = "stunner.bpmn.ScriptType";

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Boundary 01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent filledTopEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Boundary01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Boundary 01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledTopEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent emptyTopEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptyTopEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Boundary 03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent filledSubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Boundary 03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent emptySubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, false, "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Boundary 02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent filledSubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Boundary 02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent emptyEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptyEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent emptySubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Boundary 04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateConditionalEvent filledSubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Boundary 04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_ERPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateConditionalEvent> getCatchingIntermediateEventType() {
        return IntermediateConditionalEvent.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithEdgesId() {
        return FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithEdgesId() {
        return FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertConditionalEventExecutionSet(CancellingConditionalEventExecutionSet executionSet, String conditionExpressionScript, String conditionExpressionLanguage, String conditionExpressionType, boolean isCancelling, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getConditionExpression());
        Assert.assertNotNull((Object)executionSet.getConditionExpression().getValue());
        Assert.assertNotNull((Object)executionSet.getConditionExpression().getType());
        Assert.assertEquals((Object)conditionExpressionLanguage, (Object)executionSet.getConditionExpression().getValue().getLanguage());
        Assert.assertEquals((Object)conditionExpressionScript, (Object)executionSet.getConditionExpression().getValue().getScript());
        Assert.assertEquals((Object)conditionExpressionType, (Object)executionSet.getConditionExpression().getType().getName());
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertTimerEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

