/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.CatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseCatchingIntermediateEvent;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class BoundaryCatchingIntermediateEventTest<T extends BaseCatchingIntermediateEvent>
extends CatchingIntermediateEventTest<T> {
    private static final int DEFAULT_AMOUNT_OF_INCOME_EDGES = 2;

    @Test
    public void testDockerInfo() throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnCatchingIntermediateEventFilePath());
        String resultXml = this.marshaller.marshall(initialDiagram);
        XMLReader xr = XMLReaderFactory.createXMLReader();
        final HashMap dockerInfos = new HashMap();
        xr.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String s, String s1, String s2, Attributes attributes) {
                if (s1.equals("boundaryEvent")) {
                    dockerInfos.put(attributes.getValue("id"), attributes.getValue("drools:dockerinfo"));
                }
            }
        });
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream resourceAsStream = contextClassLoader.getResourceAsStream(this.getBpmnCatchingIntermediateEventFilePath());
        xr.parse(new InputSource(new InputStreamReader(resourceAsStream)));
        xr.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String s, String s1, String s2, Attributes attributes) {
                if (s1.equals("boundaryEvent")) {
                    String id = attributes.getValue("id");
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)attributes.getValue("drools:dockerinfo")).as("Attributes should match for %s", new Object[]{id})).isEqualTo(dockerInfos.remove(id));
                }
            }
        });
        xr.parse(new InputSource(new StringReader(resultXml)));
        ((MapAssert)Assertions.assertThat(dockerInfos).as("the collection should be empty at the end (100% match)", new Object[0])).isEmpty();
    }

    @Override
    @Test
    public void testMarshallTopLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledTopLevelEventId(), false, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelEventEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptyTopLevelEventId(), false, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledSubprocessLevelEventId(), false, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventId(), false, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelEventWithEdgesFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledTopLevelEventWithEdgesId(), false, true);
    }

    @Override
    @Test
    public void testMarshallTopLevelEventWithEdgesEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptyTopLevelEventWithEdgesId(), false, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledSubprocessLevelEventWithEdgesId(), false, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventWithEdgesId(), false, true);
    }

    @Override
    protected int getDefaultAmountOfIncomdeEdges() {
        return 2;
    }
}

