/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.BoundaryCatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.CancellingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class BoundaryCatchingIntermediateMessageEventTest
extends BoundaryCatchingIntermediateEventTest<IntermediateMessageEventCatching> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundaryMessageEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_7BE9AB24-2B9A-4F2B-A19B-B8447FFDEE67";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_33449EF2-534F-44D1-A2E2-8B3F37D34D25";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_839ABE26-8FA1-416A-96ED-809918924998";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_8F760A19-0D09-43B7-92BB-6469DCCA9AA1";
    private static final String EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID = "_DA50630D-D3E1-4450-AFF5-15A040162764";
    private static final String FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID = "_39105190-6879-4782-8B2B-5CCBB0DDDFFF";
    private static final String EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID = "_0E6B0C33-1B06-463C-92B2-D3C833A69EC9";
    private static final String FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID = "_8D5F7444-C0A4-4584-8C9D-CA9D8A76FABC";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 27;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary message01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message01";
        String EVENT_DATA_OUTPUT = "||message01:String||[dout]message01->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching filledTopEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Boundary message01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledTopEvent.getExecutionSet(), "message01", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "||message01:String||[dout]message01->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching emptyTopEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyTopEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary message03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message03";
        String EVENT_DATA_OUTPUT = "||message03:String||[dout]message03->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching filledSubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary message03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message03", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||message03:String||[dout]message03->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching emptySubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary message02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message02";
        String EVENT_DATA_OUTPUT = "||message02:String||[dout]message02->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching filledSubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary message02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message02", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||message02:String||[dout]message02->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching emptyEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching emptySubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary message04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message04";
        String EVENT_DATA_OUTPUT = "||message04:String||[dout]message04->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 27);
        IntermediateMessageEventCatching filledSubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary message04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message04", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||message04:String||[dout]message04->processGlobalVar");
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateMessageEventCatching> getCatchingIntermediateEventType() {
        return IntermediateMessageEventCatching.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithEdgesId() {
        return FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithEdgesId() {
        return FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertMessageEventExecutionSet(CancellingMessageEventExecutionSet executionSet, String eventName, boolean isCancelling, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getMessageRef());
        Assert.assertEquals((Object)eventName, (Object)executionSet.getMessageRef().getValue());
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertTimerEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

