/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.BoundaryCatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class BoundaryCatchingIntermediateTimerEventTest
extends BoundaryCatchingIntermediateEventTest<IntermediateTimerEvent> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundaryTimerEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_688FAF0B-C5E7-4FEB-A294-316AC5BBEC24";
    private static final String FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID = "_630B9DBB-9E07-4156-8463-FB306734FECA";
    private static final String FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID = "_0171E9A9-A11F-4011-AD46-1A8CD95FB492";
    private static final String FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID = "_7E6589B6-8087-4139-9D52-83E343D906C4";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_A9BCC6D7-A4C6-49DD-A555-B900170B05DA";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID = "_2A428CE5-2001-477E-B069-A6003281E4B1";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID = "_A6DAAF25-2DC9-468C-9454-72A6DF9775CF";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID = "_26ED8166-0AFB-4102-8646-3CE907DEF3D1";
    private static final String EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID = "_9EAB6F97-349C-4353-9B90-28AFA1D17F44";
    private static final String FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_AFTER_DURATION_ID = "_F9DA40E6-60A9-476A-8EDB-590C7930E6BE";
    private static final String FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_MULTIPLE_ID = "_227A685B-E144-4D15-B4F4-1F46343C7E58";
    private static final String FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID = "_1BBE39ED-9D13-4A85-AA43-3B2FDDD18DD2";
    private static final String EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID = "_10D8BFEE-C25C-4059-81F0-5D68EEB8B5A5";
    private static final String FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID = "_992EC0ED-950C-4CF0-B813-115BCE52AC46";
    private static final String FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID = "_3613674E-1331-4F26-8DF0-FDEAE44981A9";
    private static final String FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID = "_8B0BD7BC-32F1-42AA-8D5F-EF60E9AFB60D";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 47;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_AFTER_DURATION = "Boundary timer01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "boundary timer01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "Boundary timer02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_MULTIPLE = "boundary timer02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_MULTIPLE = "5m10s";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "cron";
        String EVENT_NAME_SPECIFIC_DATE = "Boundary timer03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "boundary timer03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T15:10:27+02:00";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent filledTopEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID, false, false);
        this.assertGeneralSet(filledTopEventAfterDuration.getGeneral(), "Boundary timer01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventAfterDuration(filledTopEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID, false, false);
        this.assertGeneralSet(filledTopEventMultiple.getGeneral(), "Boundary timer02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventMultiple(filledTopEventMultiple.getExecutionSet(), "5m10s", "cron", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID, false, false);
        this.assertGeneralSet(filledTopEventSpecificDate.getGeneral(), "Boundary timer03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventSpecificDate(filledTopEventSpecificDate.getExecutionSet(), "2018-08-13T15:10:27+02:00", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent emptyTopEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptyTopEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_AFTER_DURATION = "Boundary timer07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "boundary timer07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "Boundary timer08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_MULTIPLE = "boundary timer08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_MULTIPLE = "R3/PT8M3S";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "none";
        String EVENT_NAME_SPECIFIC_DATE = "Boundary timer09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "boundary timer09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T15:10:27+02:00";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent filledSubprocessEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, false, false);
        this.assertGeneralSet(filledSubprocessEventAfterDuration.getGeneral(), "Boundary timer07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventAfterDuration(filledSubprocessEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledSubprocessEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, false, false);
        this.assertGeneralSet(filledSubprocessEventMultiple.getGeneral(), "Boundary timer08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventMultiple(filledSubprocessEventMultiple.getExecutionSet(), "R3/PT8M3S", "none", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledSubprocessEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID, false, false);
        this.assertGeneralSet(filledSubprocessEventSpecificDate.getGeneral(), "Boundary timer09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventSpecificDate(filledSubprocessEventSpecificDate.getExecutionSet(), "2018-08-13T15:10:27+02:00", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent emptySubprocessEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptySubprocessEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME_AFTER_DURATION = "Boundary timer04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "boundary timer04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "Boundary timer05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_MULTIPLE = "boundary timer05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_MULTIPLE = "R3/PT8M3S";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "none";
        String EVENT_NAME_SPECIFIC_DATE = "Boundary timer06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "boundary timer06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T15:10:27+02:00";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent filledTopEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_AFTER_DURATION_ID, false, true);
        this.assertGeneralSet(filledTopEventAfterDuration.getGeneral(), "Boundary timer04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventAfterDuration(filledTopEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_MULTIPLE_ID, false, true);
        this.assertGeneralSet(filledTopEventMultiple.getGeneral(), "Boundary timer05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventMultiple(filledTopEventMultiple.getExecutionSet(), "R3/PT8M3S", "none", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID, false, true);
        this.assertGeneralSet(filledTopEventSpecificDate.getGeneral(), "Boundary timer06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventSpecificDate(filledTopEventSpecificDate.getExecutionSet(), "2018-08-13T15:10:27+02:00", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent emptyEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptyEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent emptySubprocessEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptySubprocessEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME_AFTER_DURATION = "Boundary timer10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "boundary timer10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "Boundary timer11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_MULTIPLE = "boundary timer11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_MULTIPLE = "5m10s";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "cron";
        String EVENT_NAME_SPECIFIC_DATE = "Boundary timer12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "boundary timer12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T15:10:27+02:00";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 47);
        IntermediateTimerEvent filledTopEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, false, true);
        this.assertGeneralSet(filledTopEventAfterDuration.getGeneral(), "Boundary timer10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventAfterDuration(filledTopEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, false, true);
        this.assertGeneralSet(filledTopEventMultiple.getGeneral(), "Boundary timer11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventMultiple(filledTopEventMultiple.getExecutionSet(), "5m10s", "cron", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID, false, true);
        this.assertGeneralSet(filledTopEventSpecificDate.getGeneral(), "Boundary timer12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "boundary timer12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertTimerEventSpecificDate(filledTopEventSpecificDate.getExecutionSet(), "2018-08-13T15:10:27+02:00", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testMarshallTopLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID, false, false);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID, false, false);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID, false, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, false, false);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, false, false);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID, false, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelEventWithEdgesFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_AFTER_DURATION_ID, false, true);
        this.checkEventMarshalling(FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_MULTIPLE_ID, false, true);
        this.checkEventMarshalling(FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID, false, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, false, true);
        this.checkEventMarshalling(FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, false, true);
        this.checkEventMarshalling(FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID, false, true);
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateTimerEvent> getCatchingIntermediateEventType() {
        return IntermediateTimerEvent.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return null;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithEdgesId() {
        return null;
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithEdgesId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertTimerEventMultiple(CancellingTimerEventExecutionSet executionSet, String timerValue, String timeCycleLanguage, boolean isCancelling, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertEquals((Object)timerValue, (Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertEquals((Object)timeCycleLanguage, (Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDate());
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertTimerEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventAfterDuration(CancellingTimerEventExecutionSet executionSet, String timerValue, boolean isCancelling, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertEquals((Object)timerValue, (Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDate());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertTimerEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventSpecificDate(CancellingTimerEventExecutionSet executionSet, String dateValue, boolean isCancelling, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertEquals((Object)dateValue, (Object)executionSet.getTimerSettings().getValue().getTimeDate());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertTimerEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventEmpty(CancellingTimerEventExecutionSet executionSet, boolean isCancelling, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDate());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertTimerEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

