/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseThrowingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class ThrowingIntermediateEventTest<T extends BaseThrowingIntermediateEvent>
extends BPMNDiagramMarshallerBaseTest {
    static final String EMPTY_VALUE = "";
    static final boolean HAS_INCOME_EDGE = true;
    static final boolean HAS_NO_INCOME_EDGE = false;

    ThrowingIntermediateEventTest() {
    }

    @Test
    public void testMarshallTopLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledTopLevelEventId(), false);
    }

    @Test
    public void testMarshallTopLevelEventEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptyTopLevelEventId(), false);
    }

    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledSubprocessLevelEventId(), false);
    }

    @Test
    public void testMarshallSubprocessLevelEventEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventId(), false);
    }

    @Test
    public void testMarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledTopLevelEventWithIncomeId(), true);
    }

    @Test
    public void testMarshallTopLevelventWithIncomeEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptyTopLevelEventWithIncomeId(), true);
    }

    @Test
    public void testMarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledSubprocessLevelEventWithIncomeId(), true);
    }

    @Test
    public void testMarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventWithIncomeId(), true);
    }

    public abstract void testUnmarshallTopLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEmptyEventProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception;

    abstract String getBpmnThrowingIntermediateEventFilePath();

    abstract Class<T> getThrowingIntermediateEventType();

    abstract String getFilledTopLevelEventId();

    abstract String getEmptyTopLevelEventId();

    abstract String getFilledSubprocessLevelEventId();

    abstract String getEmptySubprocessLevelEventId();

    abstract String getFilledTopLevelEventWithIncomeId();

    abstract String getEmptyTopLevelEventWithIncomeId();

    abstract String getFilledSubprocessLevelEventWithIncomeId();

    abstract String getEmptySubprocessLevelEventWithIncomeId();

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, boolean hasIncomeEdge) {
        T nodeBeforeMarshalling = this.getThrowingIntermediateNodeById(before, nodeId, hasIncomeEdge);
        T nodeAfterMarshalling = this.getThrowingIntermediateNodeById(after, nodeId, hasIncomeEdge);
        Assert.assertEquals(nodeBeforeMarshalling, nodeAfterMarshalling);
    }

    T getThrowingIntermediateNodeById(Diagram<Graph, Metadata> diagram, String id, boolean hasIncomeEdge) {
        Node node = diagram.getGraph().getNode(id);
        Assert.assertNotNull((Object)node);
        int incomeEdges = hasIncomeEdge ? 2 : 1;
        Assert.assertEquals((long)incomeEdges, (long)node.getInEdges().size());
        Assert.assertEquals((long)1L, (long)node.getOutEdges().size());
        return (T)((BaseThrowingIntermediateEvent)this.getThrowingIntermediateEventType().cast(((Definition)node.getContent()).getDefinition()));
    }

    void checkEventMarshalling(String nodeID, boolean hasIncomeEdge) throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnThrowingIntermediateEventFilePath());
        int AMOUNT_OF_NODES_IN_DIAGRAM = this.getNodes(initialDiagram).size();
        String resultXml = this.marshaller.marshall(initialDiagram);
        Diagram<Graph, Metadata> marshalledDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(resultXml));
        this.assertDiagram(marshalledDiagram, AMOUNT_OF_NODES_IN_DIAGRAM);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, hasIncomeEdge);
    }

    void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assert.assertNotNull((Object)generalSet);
        Assert.assertNotNull((Object)generalSet.getName());
        Assert.assertNotNull((Object)generalSet.getDocumentation());
        Assert.assertEquals((Object)nodeName, (Object)generalSet.getName().getValue());
        Assert.assertEquals((Object)documentation, (Object)generalSet.getDocumentation().getValue());
    }

    void assertDataIOSet(DataIOSet dataIOSet, String value) {
        Assert.assertNotNull((Object)dataIOSet);
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertNotNull((Object)assignmentsInfo);
        Assert.assertEquals((Object)value, (Object)assignmentsInfo.getValue());
    }
}

