/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.ThrowingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.ScopedSignalEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class ThrowingIntermediateSignalEventTest
extends ThrowingIntermediateEventTest<IntermediateSignalEventThrowing> {
    private static final String BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/throwingIntermediateSignalEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "44E0C631-6300-42D8-A6A6-186A6F8D393B";
    private static final String FILLED_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID = "713EE943-5A9C-4FA4-81C1-4F3676695DCC";
    private static final String FILLED_TOP_LEVEL_EVENT_PROJECT_SCOPE_ID = "2FABA224-9652-4410-9346-00669015F7C6";
    private static final String FILLED_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "3A0E67C8-64E1-46ED-9173-68DC8BB1FCCA";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "4FF06CD9-C0E4-4737-AE20-62A3EAA716DA";
    private static final String FILLED_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID = "F7123277-CA50-4695-BA89-46CE0B23AEA1";
    private static final String FILLED_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID = "1CFE1286-A741-4199-9589-3C5E818223AC";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "35E9A791-ED38-4DDD-9853-6214E528A2E7";
    private static final String EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID = "4ABCB559-F522-47E7-84A8-9D9F9189CDCA";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID = "0F011259-FA4F-458A-A9AB-A6C5C18257CE";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_PROJECT_SCOPE_ID = "CCDF61B4-2795-4DFD-95EC-667D56E110DB";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "3E469F07-B684-49D7-B97A-60DD22F12E01";
    private static final String EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "E7566B4F-FA5A-447F-963D-6C41C5C5A871";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID = "EFD41F08-FED7-43E9-9393-C356D7EFF7BA";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID = "11FD55C3-5370-4F15-8FC2-CCDC657C2D39";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "84FC0F13-BD60-4E18-848C-6DD63E1D93AD";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 43;
    private static final String EVENT_SIGNAL_SCOPE_DEFAULT = "";
    private static final String EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE = "processInstance";
    private static final String EVENT_SIGNAL_SCOPE_PROJECT = "project";
    private static final String EVENT_SIGNAL_SCOPE_EXTERNAL = "external";

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal01 doc\n~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal01";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal01:String||||[din]GlobalVar->signal01";
        String EVENT_NAME_PROJECT_SCOPE = "signal02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal02";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal02:String||||[din]GlobalVar->signal02";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal03";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal03:String||||[din]GlobalVar->signal03";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing filledTopEventProcessInstance = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, false);
        this.assertGeneralSet(filledTopEventProcessInstance.getGeneral(), "signal01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal01 doc\n~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProcessInstance.getExecutionSet(), "signal01", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledTopEventProcessInstance.getDataIOSet(), "signal01:String||||[din]GlobalVar->signal01");
        IntermediateSignalEventThrowing filledTopEventProject = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_PROJECT_SCOPE_ID, false);
        this.assertGeneralSet(filledTopEventProject.getGeneral(), "signal02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProject.getExecutionSet(), "signal02", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledTopEventProject.getDataIOSet(), "signal02:String||||[din]GlobalVar->signal02");
        IntermediateSignalEventThrowing filledTopEventExternal = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
        this.assertGeneralSet(filledTopEventExternal.getGeneral(), "signal03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventExternal.getExecutionSet(), "signal03", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledTopEventExternal.getDataIOSet(), "signal03:String||||[din]GlobalVar->signal03");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing emptyTopEvent = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptyTopEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal07";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal07:String||||[din]GlobalVar->signal07";
        String EVENT_NAME_PROJECT_SCOPE = "signal08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal08";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal08:String||||[din]GlobalVar->signal08";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal09";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal09:String||||[din]GlobalVar->signal09";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing filledSubprocessEventProcessInstance = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, false);
        this.assertGeneralSet(filledSubprocessEventProcessInstance.getGeneral(), "signal07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProcessInstance.getExecutionSet(), "signal07", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledSubprocessEventProcessInstance.getDataIOSet(), "signal07:String||||[din]GlobalVar->signal07");
        IntermediateSignalEventThrowing filledSubprocessEventProject = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, false);
        this.assertGeneralSet(filledSubprocessEventProject.getGeneral(), "signal08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProject.getExecutionSet(), "signal08", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledSubprocessEventProject.getDataIOSet(), "signal08:String||||[din]GlobalVar->signal08");
        IntermediateSignalEventThrowing filledSubprocessEventExternal = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
        this.assertGeneralSet(filledSubprocessEventExternal.getGeneral(), "signal09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventExternal.getExecutionSet(), "signal09", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledSubprocessEventExternal.getDataIOSet(), "signal09:String||||[din]GlobalVar->signal09");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing emptySubprocessEvent = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal04";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal04:String||||[din]GlobalVar->signal04";
        String EVENT_NAME_PROJECT_SCOPE = "signal05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal05";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal05:String||||[din]GlobalVar->signal05";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal06";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal06:String||||[din]GlobalVar->signal06";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing filledTopEventProcessInstance = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, true);
        this.assertGeneralSet(filledTopEventProcessInstance.getGeneral(), "signal04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProcessInstance.getExecutionSet(), "signal04", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledTopEventProcessInstance.getDataIOSet(), "signal04:String||||[din]GlobalVar->signal04");
        IntermediateSignalEventThrowing filledTopEventProject = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_PROJECT_SCOPE_ID, true);
        this.assertGeneralSet(filledTopEventProject.getGeneral(), "signal05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProject.getExecutionSet(), "signal05", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledTopEventProject.getDataIOSet(), "signal05:String||||[din]GlobalVar->signal05");
        IntermediateSignalEventThrowing filledTopEventExternal = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
        this.assertGeneralSet(filledTopEventExternal.getGeneral(), "signal06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventExternal.getExecutionSet(), "signal06", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledTopEventExternal.getDataIOSet(), "signal06:String||||[din]GlobalVar->signal06");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing emptyEvent = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptyEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptyEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing emptySubprocessEvent = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal10";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal10:String||||[din]GlobalVar->signal10";
        String EVENT_NAME_PROJECT_SCOPE = "signal11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal11";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal11:String||||[din]GlobalVar->signal11";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal12";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal12:String||||[din]GlobalVar->signal12";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 43);
        IntermediateSignalEventThrowing filledSubprocessEventProcessInstance = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, true);
        this.assertGeneralSet(filledSubprocessEventProcessInstance.getGeneral(), "signal10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProcessInstance.getExecutionSet(), "signal10", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledSubprocessEventProcessInstance.getDataIOSet(), "signal10:String||||[din]GlobalVar->signal10");
        IntermediateSignalEventThrowing filledSubprocessEventProject = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, true);
        this.assertGeneralSet(filledSubprocessEventProject.getGeneral(), "signal11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProject.getExecutionSet(), "signal11", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledSubprocessEventProject.getDataIOSet(), "signal11:String||||[din]GlobalVar->signal11");
        IntermediateSignalEventThrowing filledSubprocessEventExternal = (IntermediateSignalEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
        this.assertGeneralSet(filledSubprocessEventExternal.getGeneral(), "signal12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventExternal.getExecutionSet(), "signal12", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledSubprocessEventExternal.getDataIOSet(), "signal12:String||||[din]GlobalVar->signal12");
    }

    @Override
    @Test
    public void testMarshallTopLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_PROJECT_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_WITH_INCOME_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_TOP_LEVEL_PROJECT_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
    }

    @Override
    String getBpmnThrowingIntermediateEventFilePath() {
        return BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateSignalEventThrowing> getThrowingIntermediateEventType() {
        return IntermediateSignalEventThrowing.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return null;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithIncomeId() {
        return null;
    }

    @Override
    String getEmptyTopLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithIncomeId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertSignalEventExecutionSet(ScopedSignalEventExecutionSet executionSet, String signalReference, String signalScope) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getSignalRef());
        Assert.assertNotNull((Object)executionSet.getSignalScope());
        Assert.assertEquals((Object)signalReference, (Object)executionSet.getSignalRef().getValue());
        Assert.assertEquals((Object)signalScope, (Object)executionSet.getSignalScope().getValue());
    }
}

