/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.verifier.service;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kie.workbench.common.services.verifier.service.VerifierWebWorkerProvider;
import org.kie.workbench.common.services.verifier.service.VerifierWebWorkerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifierWebWorkerServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifierWebWorkerServlet.class);
    @Inject
    private VerifierWebWorkerRegistry verifierWebWorkerRegistry;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Loading verifier web worker");
        try {
            String fileName;
            String requestURI = request.getRequestURI();
            int indexOf = requestURI.indexOf("/verifier");
            if (indexOf >= 0 && (fileName = requestURI.substring(indexOf + "/verifier".length())).endsWith("cache.js")) {
                Optional<VerifierWebWorkerProvider> verifierWebWorkerProvider = this.verifierWebWorkerRegistry.get(this.trimId(fileName));
                if (!verifierWebWorkerProvider.isPresent()) {
                    LOGGER.error("Failed to load verifier web worker. Verifier with id " + fileName + " was not found.");
                } else {
                    byte[] bytes = verifierWebWorkerProvider.get().getWebWorker(fileName).getBytes();
                    response.setContentType("application/javascript");
                    response.getOutputStream().write(bytes, 0, bytes.length);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load verifier web worker.");
        }
    }

    private String trimId(String fileName) {
        String result = fileName.substring(1, fileName.length());
        result = result.substring(0, result.indexOf("/"));
        return result;
    }
}

